/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.catalog.entities.CatalogEntity;
import org.xbib.catalog.entities.CatalogEntityBuilder;
import org.xbib.catalog.entities.FieldConsolidationMapper;
import org.xbib.catalog.entities.Sequence;
import org.xbib.catalog.entities.TermFacet;
import org.xbib.catalog.entities.matching.endeavor.AuthoredWork;
import org.xbib.content.rdf.Literal;
import org.xbib.content.rdf.RdfContentBuilderProvider;
import org.xbib.content.rdf.RdfGraph;
import org.xbib.content.rdf.RdfGraphParams;
import org.xbib.content.rdf.Resource;
import org.xbib.content.rdf.internal.DefaultAnonymousResource;
import org.xbib.content.rdf.internal.DefaultLiteral;
import org.xbib.content.rdf.internal.DefaultRdfGraph;
import org.xbib.content.resource.IRI;
import org.xbib.content.resource.Node;

public class CatalogEntityWorkerState {
    private static final Logger logger = Logger.getLogger(CatalogEntityWorkerState.class.getName());
    private final IRI itemIRI = IRI.create((String)"item");
    private final CatalogEntityBuilder builder;
    private final RdfGraph<RdfGraphParams> graph;
    private final Map<IRI, RdfContentBuilderProvider<?>> builders;
    private final Map<String, TermFacet> facets;
    private final Map<String, Sequence<Resource>> sequences;
    private final Map<String, Object> scratch;
    private final String packageName;
    private final AuthoredWork authoredWorkKey;
    private String systemIdentifier;
    private String recordIdentifier;
    private String format;
    private String type;
    private String recordLabel;
    private String isil;
    private IRI uid;
    private Resource resource;
    private List<String> resourceType;
    private FieldConsolidationMapper fieldConsolidationMapper;

    public CatalogEntityWorkerState(CatalogEntityBuilder builder) {
        this.builder = builder;
        this.graph = new DefaultRdfGraph();
        this.builders = builder.contentBuilderProviders();
        this.packageName = builder.getPackageName();
        this.facets = new HashMap<String, TermFacet>();
        this.sequences = new HashMap<String, Sequence<Resource>>();
        this.authoredWorkKey = new AuthoredWork();
        this.resourceType = new ArrayList<String>();
        this.scratch = new LinkedHashMap<String, Object>();
        this.fieldConsolidationMapper = builder.getFieldConsolidationMapper();
    }

    public AuthoredWork getAuthoredWorkKey() {
        return this.authoredWorkKey;
    }

    public Map<String, Resource> getSerialsMap() {
        return this.builder.getSerialsMap();
    }

    public Map<String, Boolean> getMissingSerials() {
        return this.builder.getMissingSerials();
    }

    public CatalogEntityWorkerState setRecordLabel(String recordLabel) {
        this.recordLabel = recordLabel;
        return this;
    }

    public String getRecordLabel() {
        return this.recordLabel;
    }

    public CatalogEntityWorkerState setRecordIdentifier(String recordIdentifier) {
        this.recordIdentifier = recordIdentifier;
        return this;
    }

    public String getRecordIdentifier() {
        return this.recordIdentifier;
    }

    public CatalogEntityWorkerState addResourceType(String resourceType) {
        this.resourceType.add(resourceType);
        return this;
    }

    public List<String> getResourceType() {
        return this.resourceType;
    }

    public Resource getResource() throws IOException {
        if (!this.graph.getResources().hasNext()) {
            this.resource = new DefaultAnonymousResource();
            this.graph.receive(this.resource);
        }
        return this.resource;
    }

    public Resource getResource(IRI predicate) throws IOException {
        if (!this.graph.hasResource(predicate)) {
            DefaultAnonymousResource resource = new DefaultAnonymousResource();
            this.graph.putResource(predicate, (Resource)resource);
        }
        return this.graph.getResource(predicate);
    }

    public Resource getNextItemResource() {
        if (this.graph.hasResource(this.itemIRI)) {
            Resource resource = this.graph.removeResource(this.itemIRI);
            resource.setId(this.uid != null ? this.uid : resource.id());
            this.graph.putResource(resource.id(), resource);
        }
        this.uid = null;
        DefaultAnonymousResource item = new DefaultAnonymousResource();
        this.graph.putResource(this.itemIRI, (Resource)item);
        return item;
    }

    public Iterator<Resource> getResourceIterator() {
        return this.graph.getResources();
    }

    public String getIdentifier() {
        return this.systemIdentifier;
    }

    public CatalogEntityWorkerState setIdentifier(String identifier) {
        this.systemIdentifier = identifier;
        return this;
    }

    public String getFormat() {
        return this.format;
    }

    public CatalogEntityWorkerState setFormat(String format) {
        this.format = format;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public CatalogEntityWorkerState setType(String type) {
        this.type = type;
        return this;
    }

    public String getISIL() {
        return this.isil;
    }

    public CatalogEntityWorkerState setISIL(String isil) {
        this.isil = isil;
        return this;
    }

    public IRI getUID() {
        return this.uid;
    }

    public CatalogEntityWorkerState setUID(IRI uid) {
        this.uid = uid;
        return this;
    }

    public Map<String, TermFacet> getFacets() {
        return this.facets;
    }

    public Map<String, Sequence<Resource>> getSequences() {
        return this.sequences;
    }

    public Map<String, Object> getScratch() {
        return this.scratch;
    }

    public void finish() throws IOException {
        String facetName;
        if (this.getResource().isDeleted()) {
            return;
        }
        if (this.graph.hasResource(this.itemIRI)) {
            Resource resource = this.graph.removeResource(this.itemIRI);
            resource.setId(this.uid != null ? this.uid : resource.id());
            this.graph.putResource(resource.id(), resource);
        }
        for (Sequence sequence : this.sequences.values()) {
            String sequenceName = sequence.getName();
            if (sequenceName == null) continue;
            String[] sequencePath = sequenceName.split("\\.");
            Resource resource = this.getResource();
            if (sequencePath.length > 1) {
                for (int i = 0; i < sequencePath.length - 1; ++i) {
                    resource = resource.newResource(IRI.builder().path(sequencePath[i]).build());
                }
            }
            sequenceName = sequencePath[sequencePath.length - 1];
            IRI predicate = IRI.builder().path(sequenceName).build();
            for (Resource res : sequence.getResources()) {
                resource.add(predicate, res);
            }
        }
        this.sequences.clear();
        Map<String, Object> facetElements = this.builder.getFacetElements();
        if (facetElements != null && !facetElements.isEmpty()) {
            for (Map.Entry<String, Object> entry : facetElements.entrySet()) {
                facetName = entry.getKey();
                String facetSpec = entry.getValue().toString();
                TermFacet facet = this.facets.get(facetName);
                if (facet != null) continue;
                CatalogEntity entity = this.builder.getEntitySpecification().getEntities().get(this.packageName + "." + facetSpec);
                if (entity != null) {
                    facet = entity.getDefaultFacet();
                    if (facet == null) continue;
                    this.facets.put(facetName, facet);
                    continue;
                }
                List<Node> nodes = this.find(this.resource, facetSpec);
                if (nodes == null) continue;
                for (Node node : nodes) {
                    this.facets.putIfAbsent(facetName, new TermFacet().setName(facetName).setType(Literal.STRING));
                    String s = node instanceof Literal ? ((Literal)node).object().toString() : node.toString();
                    this.facets.get(facetName).addValue(s);
                }
            }
        }
        for (TermFacet facet : this.facets.values()) {
            facetName = facet.getName();
            if (facetName == null) continue;
            String[] facetPath = facetName.split("\\.");
            Resource resource = this.getResource();
            if (facetPath.length > 1) {
                for (int i = 0; i < facetPath.length - 1; ++i) {
                    resource = resource.newResource(IRI.builder().path(facetPath[i]).build());
                }
            }
            facetName = facetPath[facetPath.length - 1];
            IRI predicate = IRI.builder().path(facetName).build();
            for (String value : facet.getValues()) {
                DefaultLiteral literal = new DefaultLiteral((Object)value).type(facet.getType());
                try {
                    literal.object();
                    resource.add(predicate, (Literal)literal);
                }
                catch (NumberFormatException e) {
                    logger.log(Level.FINEST, e.getMessage(), e);
                }
            }
        }
        if (this.getAuthoredWorkKey().isValidWork()) {
            this.getResource().newResource("xbib").add("authoredWorkKey", this.getAuthoredWorkKey().createIdentifier());
        }
        if (this.fieldConsolidationMapper != null) {
            this.fieldConsolidationMapper.consolidate(this.getResource());
        }
        if (this.builders != null && this.graph.getResources() != null) {
            Iterator iterator = this.graph.getResources();
            while (iterator.hasNext()) {
                Resource resource = (Resource)iterator.next();
                for (RdfContentBuilderProvider<?> provider : this.builders.values()) {
                    provider.newContentBuilder().receive(resource);
                }
            }
        }
    }

    private List<Node> find(Resource res, String path) {
        Resource resource = res;
        String[] p = path.split("\\.");
        String obj = path;
        if (p.length > 1) {
            for (int i = 0; i < p.length - 1; ++i) {
                List list = resource.objects(p[i]);
                if (list.isEmpty()) continue;
                resource = (Resource)list.get(0);
            }
            obj = p[p.length - 1];
        }
        return resource.objects(obj);
    }
}

