/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities.mab;

import java.io.IOException;
import java.util.Map;
import org.xbib.catalog.entities.CatalogEntity;
import org.xbib.catalog.entities.CatalogEntityWorker;
import org.xbib.catalog.entities.CatalogEntityWorkerState;
import org.xbib.catalog.entities.TermFacet;
import org.xbib.content.rdf.Literal;
import org.xbib.marc.MarcField;

public class Country
extends CatalogEntity {
    private static final String FACET_NAME = "dc.coverage";

    public Country(Map<String, Object> params) {
        super(params);
    }

    @Override
    public CatalogEntity transform(CatalogEntityWorker worker, MarcField field) throws IOException {
        super.transform(worker, field);
        this.facetize(worker, field.getValue());
        for (MarcField.Subfield subfield : field.getSubfields()) {
            this.facetize(worker, subfield.getValue());
        }
        return this;
    }

    @Override
    protected void facetize(CatalogEntityWorker worker, String value) {
        CatalogEntityWorkerState state = worker.getWorkerState();
        state.getFacets().putIfAbsent(this.getFacetName(), new TermFacet().setName(this.getFacetName()).setType(Literal.STRING));
        TermFacet countryFacet = state.getFacets().get(this.getFacetName());
        Map countries = (Map)this.getParams().get("countryCode");
        if (countries == null) {
            return;
        }
        if (countries.containsKey(value)) {
            countryFacet.addValue((String)countries.get(value));
        }
    }

    @Override
    protected String getFacetName() {
        return FACET_NAME;
    }
}

