/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities.mab;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xbib.catalog.entities.CatalogEntity;
import org.xbib.catalog.entities.CatalogEntityWorker;
import org.xbib.content.rdf.Resource;
import org.xbib.marc.MarcField;

public class GeneralMaterialDesignation
extends CatalogEntity {
    private static final Logger logger = Logger.getLogger(GeneralMaterialDesignation.class.getName());
    private static final String FACET_NAME = "dc.format";
    private final Map<Pattern, String> patterns = new HashMap<Pattern, String>();

    public GeneralMaterialDesignation(Map<String, Object> params) {
        super(params);
        Map<String, Object> regexes = this.getRegexes();
        if (regexes != null) {
            for (Map.Entry<String, Object> entry : regexes.entrySet()) {
                String key = entry.getKey();
                this.patterns.put(Pattern.compile(Pattern.quote(key), 2), (String)regexes.get(key));
            }
        }
    }

    @Override
    public CatalogEntity transform(CatalogEntityWorker worker, MarcField field) throws IOException {
        String value = this.getValue(field);
        Resource resource = worker.getWorkerState().getResource().newResource("MaterialDesignation");
        for (String code : this.findCodes(value)) {
            resource.add("value", code);
            this.facetize(worker, code);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> findCodes(String value) {
        boolean isRAK = false;
        LinkedList<String> list = new LinkedList<String>();
        Map rak = (Map)this.getParams().get("rak");
        if (rak != null && rak.containsKey(value)) {
            list.add((String)rak.get(value));
            isRAK = true;
        }
        Map<Pattern, String> map = this.patterns;
        synchronized (map) {
            for (Map.Entry<Pattern, String> entry : this.patterns.entrySet()) {
                String v;
                Pattern p = entry.getKey();
                Matcher m = p.matcher(value);
                if (!m.find() || (v = this.patterns.get(p)) == null) continue;
                list.add(v);
            }
        }
        if (!isRAK && !list.isEmpty()) {
            logger.log(Level.WARNING, () -> MessageFormat.format("additional media types {0} detected from value: \"{1}\"", list, value));
        }
        if (list.isEmpty()) {
            logger.log(Level.WARNING, () -> MessageFormat.format("no media type detected from value: \"{0}\"", value));
        }
        return list;
    }

    @Override
    protected String getFacetName() {
        return FACET_NAME;
    }
}

