/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities.mab;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.catalog.entities.CatalogEntity;
import org.xbib.catalog.entities.CatalogEntityWorker;
import org.xbib.content.rdf.Resource;
import org.xbib.marc.MarcField;

public class RecordLeader
extends CatalogEntity {
    private static final Logger logger = Logger.getLogger(RecordLeader.class.getName());
    private final Map<String, Object> codes;

    public RecordLeader(Map<String, Object> params) {
        super(params);
        this.codes = (Map)params.get("codes");
    }

    @Override
    public CatalogEntity transform(CatalogEntityWorker worker, MarcField field) throws IOException {
        if (this.codes == null) {
            return super.transform(worker, field);
        }
        String value = this.getValue(field);
        worker.getWorkerState().setRecordLabel(value.trim());
        if (value.length() != 24) {
            logger.log(Level.WARNING, () -> MessageFormat.format("the length of this record label is {0} characters and was skipped: {1}", value.length(), value));
        }
        Resource resource = worker.getWorkerState().getResource().newResource("RecordLeader");
        for (Map.Entry<String, Object> entry : this.codes.entrySet()) {
            String code;
            String k = entry.getKey();
            int pos = Integer.parseInt(k);
            Map v = (Map)this.codes.get(k);
            String string = code = value.length() > pos ? value.substring(pos, pos + 1) : "";
            if (v.containsKey(code)) {
                resource.add((String)v.get("_predicate"), (String)v.get(code));
                continue;
            }
            logger.log(Level.WARNING, () -> MessageFormat.format("key={0} code not configured: {1}", k, code));
        }
        return super.transform(worker, field);
    }
}

