/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities.marc.hol;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.xbib.catalog.entities.CatalogEntity;
import org.xbib.catalog.entities.CatalogEntityWorker;
import org.xbib.catalog.entities.EnumerationAndChronologyHelper;
import org.xbib.content.rdf.Resource;
import org.xbib.marc.MarcField;

public class TextualHoldings
extends CatalogEntity {
    private List<Pattern> movingwallPatterns;

    public TextualHoldings(Map<String, Object> params) {
        super(params);
        List movingwalls = (List)params.get("movingwall");
        if (movingwalls != null) {
            LinkedList<Pattern> p = new LinkedList<Pattern>();
            for (String movingwall : movingwalls) {
                p.add(Pattern.compile(movingwall));
            }
            this.setMovingwallPatterns(p);
        }
    }

    public List<Pattern> getMovingwallPatterns() {
        return this.movingwallPatterns;
    }

    public void setMovingwallPatterns(List<Pattern> p) {
        this.movingwallPatterns = p;
    }

    @Override
    public CatalogEntity transform(CatalogEntityWorker worker, MarcField field) throws IOException {
        String id = worker.getWorkerState().getIdentifier();
        EnumerationAndChronologyHelper eac = new EnumerationAndChronologyHelper(id, field, this.getMovingwallPatterns());
        for (MarcField.Subfield subfield : field.getSubfields()) {
            Resource r;
            Resource parsedHoldings;
            String value = subfield.getValue();
            worker.getWorkerState().getResource().add("textualholdings", value);
            if (!"a".equals(subfield.getId()) || (parsedHoldings = eac.parseToResource(value, r = worker.getWorkerState().getResource().newResource("holdings"))).isEmpty()) continue;
            Set<Integer> dates = eac.dates(parsedHoldings);
            for (Integer date : dates) {
                worker.getWorkerState().getResource().add("dates", date);
            }
        }
        return super.transform(worker, field);
    }
}

