/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities.matching.endeavor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.catalog.entities.matching.endeavor.Identifiable;
import org.xbib.catalog.entities.matching.string.BaseformEncoder;
import org.xbib.catalog.entities.matching.string.EncoderException;
import org.xbib.catalog.entities.matching.string.WordBoundaryEntropyEncoder;

public class PublishedJournal
implements Identifiable {
    private static final Logger logger = Logger.getLogger(PublishedJournal.class.getName());
    private String journalName;
    private String publisherName;
    private String publicationType;

    public PublishedJournal journalName(String journalName) {
        this.journalName = journalName;
        return this;
    }

    public PublishedJournal publisherName(String publisherName) {
        this.publisherName = publisherName;
        return this;
    }

    public PublishedJournal publicationType(String publicationType) {
        this.publicationType = publicationType;
        return this;
    }

    @Override
    public String createIdentifier() {
        if (this.journalName == null) {
            return null;
        }
        this.journalName = this.journalName.replaceAll("\\p{P}", "");
        this.journalName = this.journalName.replaceAll(" [sS]eries$", "");
        WordBoundaryEntropyEncoder encoder = new WordBoundaryEntropyEncoder();
        StringBuilder sb = new StringBuilder();
        sb.append("s");
        String shortJournalName = BaseformEncoder.normalizedFromUTF8(this.journalName);
        int l = shortJournalName.length();
        if (l == 0) {
            shortJournalName = this.journalName;
        } else {
            try {
                shortJournalName = encoder.encode(shortJournalName);
            }
            catch (EncoderException e) {
                logger.log(Level.FINEST, e.getMessage(), e);
            }
        }
        shortJournalName = shortJournalName.replaceAll("\\s", "");
        sb.append(shortJournalName);
        if (this.publisherName != null) {
            this.publisherName = this.publisherName.replaceAll("\\p{P}", "");
            String shortPublisherName = BaseformEncoder.normalizedFromUTF8(this.publisherName);
            l = shortPublisherName.length();
            if (l == 0) {
                shortPublisherName = this.publisherName;
            } else {
                try {
                    shortPublisherName = encoder.encode(shortPublisherName);
                }
                catch (EncoderException e) {
                    logger.log(Level.FINEST, e.getMessage(), e);
                }
            }
            shortPublisherName = shortPublisherName.replaceAll("\\s", "");
            sb.append(shortPublisherName);
        }
        if (this.publicationType != null) {
            sb.append(this.publicationType);
        }
        return sb.toString();
    }
}

