/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.marc.json;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.GZIPOutputStream;
import org.xbib.content.XContentBuilder;
import org.xbib.content.json.JsonXContent;
import org.xbib.marc.Marc;
import org.xbib.marc.MarcField;
import org.xbib.marc.MarcListener;
import org.xbib.marc.MarcRecord;
import org.xbib.marc.MarcRecordListener;
import org.xbib.marc.MarcXchangeConstants;
import org.xbib.marc.label.RecordLabel;

public class MarcXchangeJSONLinesWriter
implements AutoCloseable,
MarcListener,
MarcRecordListener,
MarcXchangeConstants {
    private static final int DEFAULT_BUFFER_SIZE = 65536;
    private final AtomicInteger recordCounter = new AtomicInteger();
    private final Lock lock;
    private XContentBuilder builder;
    private OutputStream out;
    private Marc.Builder marcBuilder;
    private String format;
    private String type;
    private boolean fatalErrors;
    private Style style;
    private Exception exception;
    private String fileNamePattern;
    private AtomicInteger fileNameCounter;
    private int splitlimit;
    private int bufferSize;
    private boolean compress;
    private String index;
    private String indexType;
    private boolean top;

    public MarcXchangeJSONLinesWriter(OutputStream out) throws IOException {
        this(out, Style.LINES);
    }

    public MarcXchangeJSONLinesWriter(OutputStream out, Style style) throws IOException {
        this(out, 65536, style);
    }

    public MarcXchangeJSONLinesWriter(OutputStream out, int bufferSize, Style style) throws IOException {
        this.out = new BufferedOutputStream(out, bufferSize);
        this.bufferSize = bufferSize;
        this.lock = new ReentrantLock();
        this.builder = JsonXContent.contentBuilder((OutputStream)out);
        this.marcBuilder = Marc.builder();
        this.fatalErrors = false;
        this.style = style;
    }

    public MarcXchangeJSONLinesWriter(String fileNamePattern, int splitlimit) throws IOException {
        this(fileNamePattern, splitlimit, Style.LINES, 65536, false);
    }

    public MarcXchangeJSONLinesWriter(String fileNamePattern, int splitlimit, Style style) throws IOException {
        this(fileNamePattern, splitlimit, style, 65536, false);
    }

    public MarcXchangeJSONLinesWriter(String fileNamePattern, int splitlimit, Style style, int bufferSize, boolean compress) throws IOException {
        this.fileNameCounter = new AtomicInteger(0);
        this.fileNamePattern = fileNamePattern;
        this.splitlimit = splitlimit;
        this.bufferSize = bufferSize;
        this.lock = new ReentrantLock();
        this.marcBuilder = Marc.builder();
        this.top = true;
        this.style = style;
        this.compress = compress;
        this.builder = JsonXContent.contentBuilder((OutputStream)this.newOutputStream(fileNamePattern, this.fileNameCounter, bufferSize, compress));
    }

    public MarcXchangeJSONLinesWriter setIndex(String index, String indexType) {
        this.index = index;
        this.indexType = indexType;
        return this;
    }

    public MarcXchangeJSONLinesWriter setFatalErrors(boolean fatalErrors) {
        this.fatalErrors = fatalErrors;
        return this;
    }

    public MarcXchangeJSONLinesWriter setFormat(String format) {
        this.format = format;
        return this;
    }

    public MarcXchangeJSONLinesWriter setType(String type) {
        this.type = type;
        return this;
    }

    public void startDocument() throws IOException {
    }

    public void beginCollection() {
        if (this.style == Style.ARRAY) {
            try {
                this.builder.startArray();
            }
            catch (IOException e) {
                this.handleException(e);
            }
        }
    }

    public void record(MarcRecord marcRecord) {
        if (this.exception != null) {
            return;
        }
        this.lock.lock();
        try {
            this.toJson(marcRecord);
            this.builder.flush();
            this.recordCounter.incrementAndGet();
            this.out.write(10);
        }
        catch (IOException e) {
            this.handleException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void endCollection() {
        try {
            if (this.style == Style.ARRAY) {
                this.builder.endArray();
            }
            this.builder.flush();
            if (this.style == Style.ELASTICSEARCH_BULK) {
                this.out.write(10);
            }
            this.out.flush();
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void endDocument() throws IOException {
        this.builder.flush();
        this.out.flush();
    }

    public void beginRecord(String format, String type) {
        if (format != null) {
            this.format = format;
            this.marcBuilder.setFormat(format);
        }
        if (type != null) {
            this.type = type;
            this.marcBuilder.setType(type);
        }
    }

    public void endRecord() {
        try {
            if (this.format != null) {
                this.marcBuilder.setFormat(this.format);
            }
            if (this.type != null) {
                this.marcBuilder.setType(this.type);
            }
            this.record(this.marcBuilder.buildRecord());
            this.marcBuilder = Marc.builder();
            this.afterRecord();
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void leader(String label) {
        this.marcBuilder.recordLabel(RecordLabel.builder().from(label.toCharArray()).build());
    }

    public void field(MarcField field) {
        this.marcBuilder.addField(field);
    }

    private void toJson(MarcRecord marcRecord) throws IOException {
        if (marcRecord.isEmpty()) {
            return;
        }
        if (this.top) {
            this.top = false;
            if (this.style == Style.ELASTICSEARCH_BULK) {
                this.writeMetaDataLine(marcRecord);
            }
        } else {
            switch (this.style) {
                case ARRAY: {
                    this.out.write(44);
                    break;
                }
                case LINES: {
                    this.out.write(10);
                    break;
                }
                case ELASTICSEARCH_BULK: {
                    this.out.write(10);
                    this.writeMetaDataLine(marcRecord);
                    break;
                }
            }
        }
        this.builder.startObject();
        for (Map.Entry tags : marcRecord.entrySet()) {
            String tag = (String)tags.getKey();
            this.builder.field(tag);
            Object o = tags.getValue();
            if (o instanceof Map) {
                Map repeatMap = (Map)o;
                this.builder.startArray();
                for (Map.Entry repeats : repeatMap.entrySet()) {
                    List list;
                    o = repeats.getValue();
                    if (!(o instanceof List)) {
                        o = Collections.singletonList(o);
                    }
                    if ((list = (List)o).size() > 1) {
                        this.builder.startArray();
                    }
                    for (Object value : list) {
                        if (value instanceof Map) {
                            this.builder.startObject();
                            for (Map.Entry indicators : ((Map)value).entrySet()) {
                                String indicator = (String)indicators.getKey();
                                this.builder.field(indicator);
                                o = indicators.getValue();
                                if (!(o instanceof List)) {
                                    o = Collections.singletonList(o);
                                }
                                List list2 = (List)o;
                                this.builder.startArray();
                                for (Object value2 : list2) {
                                    if (value2 instanceof Map) {
                                        Map map = (Map)value2;
                                        for (Map.Entry subfield : map.entrySet()) {
                                            if (subfield.getValue() instanceof List) {
                                                for (String s : (List)subfield.getValue()) {
                                                    this.builder.startObject();
                                                    this.builder.field((String)subfield.getKey(), s);
                                                    this.builder.endObject();
                                                }
                                                continue;
                                            }
                                            this.builder.startObject().field((String)subfield.getKey(), subfield.getValue().toString()).endObject();
                                        }
                                        continue;
                                    }
                                    this.builder.value(value2.toString());
                                }
                                this.builder.endArray();
                            }
                            this.builder.endObject();
                            continue;
                        }
                        if (value == null) {
                            this.builder.nullValue();
                            continue;
                        }
                        this.builder.value(value.toString());
                    }
                    if (list.size() <= 1) continue;
                    this.builder.endArray();
                }
                this.builder.endArray();
                continue;
            }
            if (o == null) {
                this.builder.nullValue();
                continue;
            }
            this.builder.value(o.toString());
        }
        this.builder.endObject();
    }

    private void handleException(IOException e) {
        this.exception = e;
        if (this.fatalErrors) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.builder.close();
            this.out.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public int getRecordCounter() {
        return this.recordCounter.get();
    }

    private void afterRecord() throws IOException {
        if (this.fileNamePattern != null && this.getRecordCounter() % this.splitlimit == 0) {
            this.endCollection();
            this.close();
            this.out = this.newOutputStream(this.fileNamePattern, this.fileNameCounter, this.bufferSize, this.compress);
            this.top = true;
            this.beginCollection();
        }
    }

    private OutputStream newOutputStream(String fileNamePattern, AtomicInteger fileNameCounter, int bufferSize, boolean compress) throws IOException {
        String name = String.format(fileNamePattern, fileNameCounter.getAndIncrement());
        OutputStream outputStream = Files.newOutputStream(Paths.get(name, new String[0]), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        return compress ? new CompressedOutputStream(outputStream, bufferSize) : new BufferedOutputStream(outputStream, bufferSize);
    }

    private void writeMetaDataLine(MarcRecord marcRecord) throws IOException {
        Object object = marcRecord.get((Object)"001");
        if (object instanceof Map) {
            object = ((Map)object).values().iterator().next();
        }
        if (object instanceof Map) {
            object = ((Map)object).values().iterator().next();
        }
        String id = object.toString();
        if (this.index != null && this.indexType != null && id != null) {
            this.builder.startObject().startObject("index").field("_index", this.index).field("_type", this.type).field("_id", id).endObject().endObject();
            this.builder.flush();
            this.out.write(10);
        }
    }

    public static enum Style {
        ARRAY,
        LINES,
        ELASTICSEARCH_BULK;

    }

    private static class CompressedOutputStream
    extends GZIPOutputStream {
        CompressedOutputStream(OutputStream out, int size) throws IOException {
            super(out, size, true);
            this.def.setLevel(9);
        }
    }
}

