/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.catalog.entities.CatalogEntity;
import org.xbib.marc.MarcField;

public class CatalogEntitySpecification {
    private static final Logger logger = Logger.getLogger(CatalogEntitySpecification.class.getName());
    static final String FORMAT = "_FORMAT";
    static final String TYPE = "_TYPE";
    static final String LEADER = "_LEADER";
    private final Map<String, CatalogEntity> map;
    private final Map<String, CatalogEntity> entities;
    private final Map<String, Object> params;
    private final String packageName;

    public CatalogEntitySpecification() throws IOException {
        this((InputStream)null, new HashMap<String, CatalogEntity>(), new HashMap<String, Object>(), "org.xbib.catalog.entities.marc.bib");
    }

    public CatalogEntitySpecification(URL url, Map<String, CatalogEntity> entities, Map<String, Object> params, String packageName) throws IOException {
        this(url.openStream(), entities, params, packageName);
    }

    public CatalogEntitySpecification(InputStream inputStream, Map<String, CatalogEntity> entities, Map<String, Object> params, String packageName) throws IOException {
        this.entities = entities;
        this.params = params;
        this.packageName = packageName;
        this.map = new HashMap<String, CatalogEntity>();
        if (inputStream != null) {
            Map jsonSpec = (Map)new ObjectMapper().configure(JsonParser.Feature.ALLOW_COMMENTS, true).readValue(inputStream, Map.class);
            if (jsonSpec.isEmpty()) {
                throw new IllegalArgumentException("no spec given, this will not work at all");
            }
            this.addElements(jsonSpec, packageName);
        }
    }

    public Map<String, CatalogEntity> getMap() {
        return this.map;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Map<String, CatalogEntity> getEntities() {
        return this.entities;
    }

    public void addElements(Map<String, Map<String, Object>> jsonSpec, String packageName) throws IOException {
        for (Map.Entry<String, Map<String, Object>> entry : jsonSpec.entrySet()) {
            String key = entry.getKey();
            Map<String, Object> struct = entry.getValue();
            struct.putAll(this.params);
            CatalogEntity entity = null;
            Class<CatalogEntity> clazz = this.loadClass(this.getClass().getClassLoader(), packageName + "." + key);
            if (clazz == null) {
                clazz = this.loadClass(this.getClass().getClassLoader(), key);
            }
            if (clazz != null) {
                try {
                    entity = clazz.getDeclaredConstructor(Map.class).newInstance(struct);
                }
                catch (Exception e1) {
                    logger.log(Level.FINE, "can't get declared constructor of class " + clazz.getName(), e1);
                    try {
                        entity = clazz.newInstance();
                    }
                    catch (Exception e2) {
                        logger.log(Level.SEVERE, "can't instantiate class " + clazz.getName(), e2);
                    }
                }
                if (entity != null) {
                    this.entities.put(packageName + "." + key, entity);
                }
            }
            Collection<Object> values = null;
            Object tags = struct.get("tags");
            if (tags instanceof Map) {
                values = ((Map)tags).keySet();
            } else if (tags instanceof Collection) {
                values = (Collection)tags;
            }
            if (values == null) continue;
            for (String string : values) {
                this.associate(string, entity);
            }
        }
    }

    public CatalogEntitySpecification associate(MarcField marcField, CatalogEntity entity) {
        return this.associate(marcField.toTagKey(), entity);
    }

    public CatalogEntitySpecification associate(String key, CatalogEntity entity) {
        String k = this.clean(key);
        if (this.map.containsKey(k)) {
            logger.log(Level.WARNING, () -> MessageFormat.format("key {0} already exist: {1}", k, key));
            return this;
        }
        this.map.put(k, entity);
        return this;
    }

    public CatalogEntity retrieve(MarcField marcField) {
        return this.retrieve(marcField.toTagKey());
    }

    public CatalogEntity retrieveFormat() {
        return this.map.get(FORMAT);
    }

    public CatalogEntity retrieveType() {
        return this.map.get(TYPE);
    }

    public CatalogEntity retrieveLeader() {
        return this.map.get(LEADER);
    }

    public CatalogEntity retrieve(String key) {
        return this.map.get(this.clean(key));
    }

    public void dump(Writer writer) throws IOException {
        new ObjectMapper().writeValue(writer, (Object)this);
    }

    private String clean(String key) {
        int pos = key.indexOf(36);
        return pos > 0 ? key.substring(0, pos) : key;
    }

    private Class<CatalogEntity> loadClass(ClassLoader cl, String className) {
        Class<CatalogEntity> clazz = null;
        try {
            clazz = cl.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e1) {
                logger.log(Level.FINER, "Class.forName() failed: " + e1.getMessage(), e1);
                try {
                    clazz = ClassLoader.getSystemClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException e2) {
                    logger.log(Level.FINER, "ClassLoader.getSystemClassLoader() failed: " + e2.getMessage(), e2);
                    logger.log(Level.SEVERE, "class not found: " + e.getMessage(), e);
                }
            }
        }
        return clazz;
    }
}

