/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities.marc.bib;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xbib.catalog.entities.CatalogEntity;
import org.xbib.catalog.entities.CatalogEntityWorker;
import org.xbib.content.rdf.Resource;

public class ClassificationNumber
extends CatalogEntity {
    private static final String SCRATCH_KEY = "classificationNumber";
    private final Map<String, String> ddcMap;
    private final Map<String, String> dnbMap;

    public ClassificationNumber(Map<String, Object> params) {
        super(params);
        this.ddcMap = (Map)params.get("ddc");
        this.dnbMap = (Map)params.get("dnb");
    }

    @Override
    public List<String> transform(CatalogEntityWorker worker, String predicate, Resource resource, String property, String value) {
        Map<String, Object> scratch = worker.getWorkerState().getScratch();
        if (SCRATCH_KEY.equals(property)) {
            scratch.putIfAbsent(SCRATCH_KEY, new LinkedList());
            List values = (List)scratch.get(SCRATCH_KEY);
            values.add(value);
            scratch.put(SCRATCH_KEY, values);
        }
        if ("type".equals(property)) {
            switch (value) {
                case "DNB": {
                    List dnbValues = (List)scratch.get(SCRATCH_KEY);
                    for (String dnbValue : dnbValues) {
                        resource.add("dnb", this.dnbMap != null ? this.dnbMap.get(dnbValue) : null);
                    }
                    scratch.remove(SCRATCH_KEY);
                    break;
                }
                case "DDC": {
                    List ddcValues = (List)scratch.get(SCRATCH_KEY);
                    for (String ddcValue : ddcValues) {
                        resource.add("ddc", this.ddcMap != null ? this.ddcMap.get(ddcValue) : null);
                    }
                    scratch.remove(SCRATCH_KEY);
                    break;
                }
            }
        }
        return Collections.singletonList(value);
    }
}

