/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities.matching.name;

import java.text.Normalizer;
import java.util.TreeSet;
import org.xbib.catalog.entities.matching.Domain;
import org.xbib.catalog.entities.matching.DomainKey;
import org.xbib.catalog.entities.matching.string.EncoderException;
import org.xbib.catalog.entities.matching.string.HaasePhonetikEncoder;

public class GermanNameKey
extends TreeSet<String>
implements DomainKey<String> {
    private static final long serialVersionUID = 740094768192592666L;
    private char delimiter = (char)47;

    @Override
    public Domain getDomain() {
        return Domain.CREATOR;
    }

    @Override
    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    @Override
    public char getDelimiter() {
        return this.delimiter;
    }

    @Override
    public boolean isUsable() {
        return !this.isEmpty();
    }

    @Override
    public boolean add(String value) {
        for (String s : value.split("\\p{P}|\\p{Z}")) {
            String normalized = this.normalize(s);
            int n = this.size();
            if (n >= 5 || normalized.length() <= 2 && n >= 1) continue;
            super.add(normalized);
        }
        return true;
    }

    @Override
    public String encode() throws EncoderException {
        HaasePhonetikEncoder enc = new HaasePhonetikEncoder();
        StringBuilder sb = new StringBuilder();
        for (String s : this) {
            String encoded = enc.encode(s);
            if (encoded.length() <= 0) continue;
            sb.append(encoded).append(this.delimiter);
        }
        int len = sb.length();
        if (len > 0) {
            sb.deleteCharAt(len - 1);
        }
        return sb.toString();
    }

    protected String normalize(String value) {
        String s = value.replaceAll("[^\\p{L}\\p{N}]", "");
        return Normalizer.normalize(s, Normalizer.Form.NFD);
    }

    @Override
    public boolean equals(Object object) {
        return this == object || object instanceof GermanNameKey && this.hashCode() == object.hashCode();
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }
}

