/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities.matching.string;

import java.util.Arrays;
import java.util.List;
import org.xbib.catalog.entities.matching.string.EncoderException;
import org.xbib.catalog.entities.matching.string.StringEncoder;

public class SoundexEncoder
implements StringEncoder {
    private static final List<Character> US_ENGLISH_MAPPING = Arrays.asList(Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('0'), Character.valueOf('0'), Character.valueOf('2'), Character.valueOf('2'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('5'), Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('6'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('0'), Character.valueOf('2'), Character.valueOf('0'), Character.valueOf('2'));
    public static final SoundexEncoder US_ENGLISH = new SoundexEncoder();
    private List<Character> soundexMapping;
    private int maxLength = 4;

    public SoundexEncoder() {
        this(US_ENGLISH_MAPPING);
    }

    public SoundexEncoder(List<Character> mapping) {
        this.soundexMapping = mapping;
    }

    @Override
    public String encode(String str) throws EncoderException {
        char mapped;
        if (null == str || str.length() == 0) {
            return str;
        }
        char[] out = new char[]{'0', '0', '0', '0'};
        int incount = 1;
        int count = 1;
        out[0] = Character.toUpperCase(str.charAt(0));
        char last = this.getMappingCode(str.charAt(0));
        while (incount < str.length() && (mapped = this.getMappingCode(str.charAt(incount++))) != '\u0000' && count < this.maxLength) {
            if (mapped != '0' && mapped != last) {
                out[count++] = mapped;
            }
            last = mapped;
        }
        return new String(out);
    }

    private char getMappingCode(char c) {
        if (!Character.isLetter(c)) {
            return '\u0000';
        }
        return this.soundexMapping.get(Character.toUpperCase(c) - 65).charValue();
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }
}

