/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.content.rdf.Literal;
import org.xbib.content.rdf.Resource;
import org.xbib.content.rdf.internal.DefaultLiteral;
import org.xbib.content.resource.IRI;
import org.xbib.content.resource.Node;
import org.xbib.content.settings.Settings;

public class FieldConsolidationMapper {
    private static final Logger logger = Logger.getLogger(FieldConsolidationMapper.class.getName());
    private Map<String, Object> source;
    private Map<String, Object> target;
    private List<String> targetKeys;

    public FieldConsolidationMapper(Settings settings) throws IOException {
        String resource = settings.get("field_mapping_source");
        this.source = resource != null && resource.endsWith(".json") ? (Map)new ObjectMapper().readValue(this.getClass().getClassLoader().getResource(resource).openStream(), Map.class) : settings.getAsSettings("field_mapping_source").getAsStructuredMap();
        resource = settings.get("field_mapping_target");
        this.target = resource != null && resource.endsWith(".json") ? (Map)new ObjectMapper().readValue(this.getClass().getClassLoader().getResource(resource).openStream(), Map.class) : settings.getAsSettings("field_mapping_target").getAsStructuredMap();
        this.targetKeys = Arrays.asList(settings.getAsArray("field_mapping_target_keys"));
        logger.log(Level.INFO, () -> MessageFormat.format("field mapper source: {0} target: {1} target keys: {2}", this.source.size(), this.target.size(), this.targetKeys));
    }

    public void consolidate(Resource root) {
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        for (Map.Entry<String, Object> entry : this.source.entrySet()) {
            String sourceField = entry.getKey();
            Map sourceValues = (Map)entry.getValue();
            List<Node> sourceNodes = this.find(root, sourceField);
            if (sourceNodes == null) continue;
            for (Node node : sourceNodes) {
                String value = node instanceof Literal ? ((Literal)node).object().toString() : node.toString();
                if (!sourceValues.containsKey(value)) continue;
                List targetValues = (List)sourceValues.get(value);
                this.push(result, this.targetKeys, targetValues);
            }
        }
        for (Map.Entry<String, Object> entry : result.entrySet()) {
            Resource resource = root;
            String name = entry.getKey();
            List<Node> list = this.find(root, name);
            String[] path = name.split("\\.");
            if (path.length > 1) {
                for (int i = 0; i < path.length - 1; ++i) {
                    resource = resource.newResource(IRI.builder().path(path[i]).build());
                }
            }
            name = path[path.length - 1];
            IRI predicate = IRI.builder().path(name).build();
            for (String value : (List)entry.getValue()) {
                DefaultLiteral literal = new DefaultLiteral((Object)value).type(Literal.STRING);
                if (list.contains(literal)) continue;
                resource.add(predicate, (Literal)literal);
            }
        }
    }

    private void push(Map<String, List<String>> result, List<String> targetKeys, List<String> targetValues) {
        for (String key : targetKeys) {
            Map map = (Map)this.target.get(key);
            for (String value : targetValues) {
                String translation;
                if (!map.containsKey(value) || (translation = (String)map.get(value)) == null) continue;
                result.putIfAbsent(key, new ArrayList());
                List<String> list = result.get(key);
                list.add(translation);
                result.put(key, list);
            }
        }
    }

    private List<Node> find(Resource res, String path) {
        Resource resource = res;
        String[] p = path.split("\\.");
        String obj = path;
        if (p.length > 1) {
            for (int i = 0; i < p.length - 1; ++i) {
                List list = resource.objects(p[i]);
                if (list.isEmpty()) continue;
                resource = (Resource)list.get(0);
            }
            obj = p[p.length - 1];
        }
        return resource.objects(obj);
    }
}

