/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities.mab;

import java.io.IOException;
import java.util.Map;
import org.xbib.catalog.entities.CatalogEntity;
import org.xbib.catalog.entities.CatalogEntityWorker;
import org.xbib.content.rdf.Resource;
import org.xbib.marc.MarcField;

public class SerialType
extends CatalogEntity {
    private static final String FACET_NAME = "dc.type";
    private Map<String, Object> codes = this.getCodes();
    private Map<String, Object> facetcodes = this.getFacetCodes();

    public SerialType(Map<String, Object> params) {
        super(params);
    }

    @Override
    public CatalogEntity transform(CatalogEntityWorker worker, MarcField field) throws IOException {
        String value = this.getValue(field);
        if (this.codes != null) {
            Resource resource = worker.getWorkerState().getResource().newResource("Type");
            for (int i = 0; i < value.length(); ++i) {
                Map q = (Map)this.codes.get(Integer.toString(i));
                if (q == null) continue;
                String code = (String)q.get(value.substring(i, i + 1));
                if (code == null && i + 1 < value.length()) {
                    code = (String)q.get(value.substring(i, i + 2));
                }
                resource.add("value", code);
            }
        }
        if (this.facetcodes != null) {
            for (int i = 0; i < value.length(); ++i) {
                Map q = (Map)this.facetcodes.get(Integer.toString(i));
                if (q == null) continue;
                String code = (String)q.get(value.substring(i, i + 1));
                if (code == null && i + 1 < value.length()) {
                    code = (String)q.get(value.substring(i, i + 2));
                }
                if (code == null) continue;
                this.facetize(worker, code);
            }
        }
        return null;
    }

    @Override
    protected String getFacetName() {
        return FACET_NAME;
    }
}

