/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities.matching;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.catalog.entities.matching.CompositeKey;
import org.xbib.catalog.entities.matching.DefaultKey;
import org.xbib.catalog.entities.matching.Domain;
import org.xbib.catalog.entities.matching.DomainKey;
import org.xbib.catalog.entities.matching.InvalidDomainException;
import org.xbib.catalog.entities.matching.string.EncoderException;

public class DefaultCompositeKey<T>
extends AbstractCollection<DomainKey<T>>
implements CompositeKey<T> {
    private static final Logger logger = Logger.getLogger(DefaultCompositeKey.class.getName());
    private final List<DomainKey<T>> list = new LinkedList<DomainKey<T>>();
    private char delimiter;
    private char componentDelimiter;
    private String key;
    private boolean usable;

    public DefaultCompositeKey() {
        this(':', '/');
    }

    public DefaultCompositeKey(char componentDelimiter, char delimiter) {
        this.componentDelimiter = componentDelimiter;
        this.delimiter = delimiter;
    }

    @Override
    public boolean add(DomainKey<T> component) {
        return this.list.add(component);
    }

    @Override
    public Iterator<DomainKey<T>> iterator() {
        return this.list.iterator();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public URI encodeToURI(String prefix) throws URISyntaxException, EncoderException {
        if (this.key == null) {
            this.key = this.encodeKey(new StringBuilder(prefix));
        }
        return URI.create(this.key);
    }

    @Override
    public String encodeToString() throws EncoderException {
        if (this.key == null) {
            this.key = this.encodeKey(new StringBuilder());
        }
        return this.key;
    }

    @Override
    public void update(DomainKey<T> component) {
        for (int i = 0; i < this.size(); ++i) {
            DomainKey<T> segment = this.list.get(i);
            if (!component.getDomain().equals((Object)segment.getDomain())) continue;
            this.list.set(i, component);
        }
    }

    @Override
    public DomainKey<T> getComponent(Domain domain) {
        for (DomainKey<T> segment : this) {
            if (!domain.equals((Object)segment.getDomain())) continue;
            return segment;
        }
        return null;
    }

    public boolean isUsable() {
        boolean anyusable = false;
        for (DomainKey<T> segment : this) {
            anyusable = anyusable || segment.isUsable();
        }
        return anyusable;
    }

    @Override
    public void setUsable(boolean usable) {
        this.usable = usable;
    }

    @Override
    public boolean getUsable() {
        return this.usable;
    }

    public static DefaultCompositeKey<String> parse(URI key, char componentDelimiter, char delimiter) {
        DefaultCompositeKey<String> k = new DefaultCompositeKey<String>(componentDelimiter, delimiter);
        for (String s : key.getSchemeSpecificPart().split(String.valueOf(componentDelimiter))) {
            if (s.length() <= 0) continue;
            String domain = s.substring(0, 1);
            String value = s.substring(1);
            try {
                k.add(new DefaultKey(Domain.getDomain(domain), value));
            }
            catch (InvalidDomainException e) {
                logger.log(Level.FINE, e.getMessage(), e);
            }
        }
        return k;
    }

    @Override
    public String toString() {
        try {
            return this.encodeToString();
        }
        catch (EncoderException e) {
            logger.log(Level.FINE, e.getMessage(), e);
            return "EncoderException: " + e.getMessage();
        }
    }

    private String encodeKey(StringBuilder sb) throws EncoderException {
        for (DomainKey<T> segment : this) {
            if (!segment.isUsable()) continue;
            char segmentDelimiter = segment.getDelimiter();
            segment.setDelimiter(this.delimiter);
            sb.append((Object)segment.getDomain()).append(segment.encode()).append(this.componentDelimiter);
            segment.setDelimiter(segmentDelimiter);
        }
        int len = sb.length();
        if (len > 1) {
            sb.deleteCharAt(len - 1);
        }
        return sb.toString();
    }
}

