/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities.matching.endeavor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.xbib.catalog.entities.matching.endeavor.Key;
import org.xbib.catalog.entities.matching.string.BaseformEncoder;
import org.xbib.catalog.entities.matching.string.EncoderException;
import org.xbib.catalog.entities.matching.string.WordBoundaryEntropyEncoder;

public class PublishedJournalKey
implements Key {
    private List<String> titles = new ArrayList<String>();
    private List<String> publishingEntities = new ArrayList<String>();
    private String publicationType;

    public PublishedJournalKey addTitle(String title) {
        if (title != null) {
            this.titles.addAll(this.split(this.clean(title)));
        }
        return this;
    }

    public void addTitle(Collection<String> titles) {
        if (titles != null) {
            titles.stream().filter(Objects::nonNull).forEach(this::addTitle);
        }
    }

    public void addPublishingEntity(String entity) {
        if (entity != null) {
            this.publishingEntities.addAll(this.split(this.clean(entity)));
        }
    }

    public void addPublishingEntity(Collection<String> entity) {
        if (entity != null) {
            entity.stream().filter(Objects::nonNull).forEach(this::addPublishingEntity);
        }
    }

    public void setPublicationType(String publicationType) {
        this.publicationType = publicationType;
    }

    public boolean isValidJournalKey() {
        return this.titles.size() > 0 && this.publishingEntities.size() > 0;
    }

    @Override
    public String createKey() {
        WordBoundaryEntropyEncoder encoder = new WordBoundaryEntropyEncoder();
        StringBuilder sb = new StringBuilder();
        for (String title : this.titles) {
            title = title.replaceAll("\\p{P}", "").replaceAll(" [sS]eries$", "");
            sb.append("s");
            String shortJournalName = BaseformEncoder.normalizedFromUTF8(title);
            if (shortJournalName.length() == 0) {
                shortJournalName = title;
            } else {
                try {
                    shortJournalName = encoder.encode(shortJournalName);
                }
                catch (EncoderException encoderException) {
                    // empty catch block
                }
            }
            shortJournalName = shortJournalName.replaceAll("\\s", "");
            sb.append(shortJournalName);
        }
        encoder = new WordBoundaryEntropyEncoder();
        for (String publishingEntity : this.publishingEntities) {
            String shortPublisherName = BaseformEncoder.normalizedFromUTF8(publishingEntity = publishingEntity.replaceAll("\\p{P}", ""));
            if (shortPublisherName.length() == 0) {
                shortPublisherName = publishingEntity;
            } else {
                try {
                    shortPublisherName = encoder.encode(shortPublisherName);
                }
                catch (EncoderException encoderException) {
                    // empty catch block
                }
            }
            shortPublisherName = shortPublisherName.replaceAll("\\s", "");
            sb.append(shortPublisherName);
        }
        if (this.publicationType != null) {
            sb.append(this.publicationType);
        }
        return sb.toString();
    }

    protected String clean(String value) {
        if (value == null) {
            return null;
        }
        String s = value;
        int pos = s.indexOf("/ ");
        if (pos > 0) {
            s = s.substring(0, pos);
        }
        s = s.replaceAll("\\[.*?\\]", "").trim();
        return s;
    }

    protected List<String> split(String string) {
        String t = string;
        ArrayList<String> list = new ArrayList<String>();
        if (t != null) {
            t = t.replaceAll(" ; ", "\n").replaceAll(" / ", "\n").replaceAll(" = ", "\n");
            for (String s : t.split("\n")) {
                if (s == null || "[...]".equals(s)) continue;
                if (s.startsWith("= ")) {
                    s = s.substring(2);
                }
                list.add(s.trim());
            }
        }
        return list;
    }
}

