/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities.matching.name;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.catalog.entities.matching.endeavor.Key;
import org.xbib.catalog.entities.matching.string.BaseformEncoder;
import org.xbib.catalog.entities.matching.string.EncoderException;
import org.xbib.catalog.entities.matching.string.WordBoundaryEntropyEncoder;

public class Author
implements Key {
    private static final Logger logger = Logger.getLogger(Author.class.getName());
    private StringBuilder authorName;
    private final WordBoundaryEntropyEncoder encoder = new WordBoundaryEntropyEncoder();

    public Author authorName(Collection<String> authorNames) {
        authorNames.forEach(this::authorName);
        return this;
    }

    public Author authorName(String authorName) {
        block8: {
            String[] s;
            if (authorName == null) {
                return this;
            }
            if (this.authorName == null) {
                this.authorName = new StringBuilder();
            }
            if ((s = authorName.split("\\s+")).length <= 0) break block8;
            if (s[0].indexOf(44) >= 0) {
                String lastname = s[0];
                this.authorName.append(lastname);
                if (s.length > 1) {
                    this.authorName.append(' ');
                }
                for (int i = 1; i < s.length; ++i) {
                    if (s[i].length() <= 0) continue;
                    this.authorName.append(s[i].charAt(0));
                }
            } else {
                String lastName = s[s.length - 1];
                this.authorName.append(lastName);
                if (s.length > 1) {
                    this.authorName.append(' ');
                }
                for (int i = 0; i < s.length - 1; ++i) {
                    if (s[i].length() <= 0) continue;
                    this.authorName.append(s[i].charAt(0));
                }
            }
        }
        return this;
    }

    public Author authorNameWithForeNames(String lastName, String foreName) {
        if (foreName == null) {
            return this.authorName(lastName);
        }
        StringBuilder sb = new StringBuilder();
        for (String s : foreName.split("\\s+")) {
            if (s.length() <= 0) continue;
            sb.append(s.charAt(0));
        }
        if (lastName != null) {
            if (this.authorName == null) {
                this.authorName = new StringBuilder(lastName);
                if (sb.length() > 0) {
                    this.authorName.append(' ').append((CharSequence)sb);
                }
            } else {
                this.authorName.append(lastName);
                if (sb.length() > 0) {
                    this.authorName.append(' ').append((CharSequence)sb);
                }
            }
        }
        return this;
    }

    public Author authorNameWithInitials(String lastName, String initials) {
        String s = initials;
        if (s != null) {
            s = s.replaceAll("\\s+", "");
        }
        if (lastName != null) {
            if (this.authorName == null) {
                this.authorName = new StringBuilder(lastName);
                if (s != null && s.length() > 0) {
                    this.authorName.append(' ').append(s);
                }
            } else {
                this.authorName.append(lastName);
                if (s != null && s.length() > 0) {
                    this.authorName.append(' ').append(s);
                }
            }
        }
        return this;
    }

    @Override
    public String createKey() {
        StringBuilder sb = new StringBuilder();
        if (this.authorName != null) {
            String aName = BaseformEncoder.normalizedFromUTF8(this.authorName.toString()).replaceAll("aeiou", "");
            try {
                aName = this.encoder.encode(aName);
            }
            catch (EncoderException e) {
                logger.log(Level.FINE, e.getMessage(), e);
            }
            sb.append(aName);
        }
        return sb.toString();
    }
}

