/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities.mab;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xbib.catalog.entities.CatalogEntity;
import org.xbib.catalog.entities.CatalogEntityWorker;
import org.xbib.catalog.entities.TermFacet;
import org.xbib.content.rdf.Literal;
import org.xbib.marc.MarcField;

public class Extent
extends CatalogEntity {
    private static final Logger logger = Logger.getLogger(Extent.class.getName());
    private String facet = "dc.format";
    private Map<Pattern, String> patterns;

    public Extent(Map<String, Object> params) {
        super(params);
        Map regexes;
        if (params.containsKey("_facet")) {
            this.facet = params.get("_facet").toString();
        }
        if ((regexes = (Map)this.getParams().get("regexes")) != null) {
            this.patterns = new HashMap<Pattern, String>();
            for (Map.Entry entry : regexes.entrySet()) {
                String key = (String)entry.getKey();
                this.patterns.put(Pattern.compile(Pattern.quote(key), 2), (String)regexes.get(key));
            }
        }
        logger.log(Level.FINE, () -> MessageFormat.format("Pattern for extent format detection: {0}", this.patterns));
    }

    @Override
    public CatalogEntity transform(CatalogEntityWorker worker, MarcField field) throws IOException {
        String value = this.getValue(field);
        for (String code : this.findCodes(value)) {
            worker.getWorkerState().getFacets().putIfAbsent(this.facet, new TermFacet().setName(this.facet).setType(Literal.STRING));
            worker.getWorkerState().getFacets().get(this.facet).addValue(code);
        }
        return this;
    }

    private List<String> findCodes(String value) {
        LinkedList<String> list = new LinkedList<String>();
        if (this.patterns != null) {
            for (Map.Entry<Pattern, String> entry : this.patterns.entrySet()) {
                String v;
                Pattern p = entry.getKey();
                Matcher m = p.matcher(value);
                if (!m.find() || (v = this.patterns.get(p)) == null) continue;
                list.add(v);
            }
        }
        return list;
    }
}

