/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities.marc.bib;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.catalog.entities.CatalogEntity;
import org.xbib.catalog.entities.CatalogEntityWorker;
import org.xbib.content.rdf.Resource;

public class Identifier
extends CatalogEntity {
    private static final Logger logger = Logger.getLogger(Identifier.class.getName());
    private final Set<String> unrecognized = new HashSet<String>();

    public Identifier(Map<String, Object> params) {
        super(params);
    }

    @Override
    public List<String> transform(CatalogEntityWorker worker, String predicate, Resource resource, String property, String value) {
        if ("IdentifierZDB".equals(predicate) && "value".equals(property)) {
            String prefix;
            if (value.startsWith("(DE-599)")) {
                resource.add("identifierEKI", value.substring(8));
                return null;
            }
            if (value.startsWith("(OCoLC)")) {
                resource.add("identifierOCLC", value.substring(7).replaceAll("\\-", "").toLowerCase());
                return null;
            }
            int begin = value.indexOf(40);
            int end = value.lastIndexOf(41);
            if (end > begin && begin >= 0 && !this.unrecognized.contains(prefix = value.substring(begin + 1, end - 1))) {
                this.unrecognized.add(prefix);
                logger.log(Level.WARNING, () -> MessageFormat.format("unprocessed identifier prefix: {0}", prefix));
            }
            return null;
        }
        return Collections.singletonList(value);
    }
}

