/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import org.xbib.catalog.entities.CatalogEntity;
import org.xbib.catalog.entities.CatalogEntityBuilder;
import org.xbib.catalog.entities.CatalogEntityWorkerState;
import org.xbib.catalog.entities.Classifier;
import org.xbib.catalog.entities.IdentifierMapper;
import org.xbib.catalog.entities.StatusCodeMapper;
import org.xbib.catalog.entities.Worker;
import org.xbib.content.rdf.Resource;
import org.xbib.content.resource.IRI;
import org.xbib.marc.MarcField;
import org.xbib.marc.MarcRecord;

public class CatalogEntityWorker
implements Worker<MarcRecord> {
    private static final Logger logger = Logger.getLogger(CatalogEntityWorker.class.getName());
    private static final IRI tempPredicate = IRI.create((String)"tmp");
    private final CatalogEntityBuilder entityBuilder;
    private final CRC32 crc32;
    private CatalogEntityWorkerState state;

    public CatalogEntityWorker(CatalogEntityBuilder entityBuilder) {
        this.entityBuilder = entityBuilder;
        this.crc32 = new CRC32();
    }

    private static Map.Entry<String, Object> subfieldDecoderMap(Map<String, Object> subfields, MarcField.Subfield field) {
        String k = null;
        String v = field.getValue();
        Object subfieldDef = subfields.get(field.getId());
        if (subfieldDef instanceof Map) {
            Map subfieldmap = (Map)subfieldDef;
            if (subfieldmap.containsKey(v.toString())) {
                Object o = subfieldmap.get(v.toString());
                if (o instanceof Map) {
                    Map.Entry me = ((Map)o).entrySet().iterator().next();
                    k = (String)me.getKey();
                    v = me.getValue();
                } else {
                    v = o;
                }
            }
        } else {
            k = (String)subfieldDef;
        }
        final String newKey = k;
        final String newValue = v;
        return new Map.Entry<String, Object>(){

            @Override
            public String getKey() {
                return newKey;
            }

            @Override
            public Object getValue() {
                return newValue;
            }

            @Override
            public Object setValue(Object value) {
                return null;
            }
        };
    }

    private CatalogEntityWorkerState newState() {
        return new CatalogEntityWorkerState(this.entityBuilder);
    }

    @Override
    public void execute(MarcRecord marcRecord) throws IOException {
        try {
            this.state = this.newState();
            this.build(marcRecord);
        }
        finally {
            this.entityBuilder.beforeFinishState(this.state);
            this.state.finish();
            this.entityBuilder.afterFinishState(this.state);
        }
    }

    public CatalogEntityWorkerState getWorkerState() {
        return this.state;
    }

    public Classifier classifier() {
        return this.entityBuilder.getClassifier();
    }

    public IdentifierMapper identifierMapper() {
        return this.entityBuilder.getIdentifierMapper();
    }

    public StatusCodeMapper statusCodeMapper() {
        return this.entityBuilder.getStatusMapper();
    }

    public void build(MarcRecord marcRecord) throws IOException {
        if (this.entityBuilder.isEnableChecksum()) {
            this.crc32.reset();
        }
        for (MarcField marcField : marcRecord.getFields()) {
            this.build(marcField);
        }
        if (this.entityBuilder.isEnableChecksum()) {
            this.crc32.update(marcRecord.getFields().toString().getBytes(StandardCharsets.UTF_8));
            this.getWorkerState().getResource().add(IRI.builder().curie("crc").build(), Long.toHexString(this.crc32.getValue()));
            this.entityBuilder.checksum(this.crc32);
        }
        this.entityBuilder.getCounter().incrementAndGet();
    }

    public void build(MarcField marcField) throws IOException {
        if (!marcField.isTagValid()) {
            this.entityBuilder.invalid(this.getWorkerState().getRecordIdentifier(), marcField, "field " + marcField + ": invalid tag");
            return;
        }
        if (!marcField.isIndicatorValid()) {
            this.entityBuilder.invalid(this.getWorkerState().getRecordIdentifier(), marcField, "field " + marcField + " invalid indicator");
            return;
        }
        CatalogEntity entity = this.entityBuilder.getEntitySpecification().retrieve(marcField);
        if (entity != null) {
            entity.transform(this, marcField);
            this.entityBuilder.mapped(this.getWorkerState().getRecordIdentifier(), marcField);
        } else {
            this.entityBuilder.unmapped(this.getWorkerState().getRecordIdentifier(), marcField, "field " + marcField + " tag definition missing in specification");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "field=" + marcField + " entity=" + entity);
        }
    }

    public Resource append(Resource resource, MarcField field, CatalogEntity entity) throws IOException {
        Map<String, Object> params = entity.getParams();
        Map defaultSubfields = (Map)params.get("subfields");
        if (defaultSubfields == null) {
            return resource;
        }
        HashMap<MarcField, String> fieldNames = new HashMap<MarcField, String>();
        Resource newResource = resource.newResource(tempPredicate);
        String predicate = entity.getClass().getSimpleName();
        if (params.containsKey("_predicate")) {
            predicate = (String)params.get("_predicate");
        }
        boolean overridePredicate = false;
        for (MarcField.Subfield subfield : field.getSubfields()) {
            Map.Entry<String, Object> me;
            Map indicatorMap;
            Map indicators;
            Map tags;
            Object o;
            Map subfields = defaultSubfields;
            if (params.containsKey("tags") && (o = params.get("tags")) instanceof Map && (tags = (Map)o).containsKey(field.getTag())) {
                if (!overridePredicate) {
                    predicate = (String)tags.get(field.getTag());
                }
                if ((subfields = (Map)params.get(predicate)) == null) {
                    subfields = defaultSubfields;
                }
            }
            if (params.containsKey("indicators") && (indicators = (Map)params.get("indicators")).containsKey(field.getTag()) && (indicatorMap = (Map)indicators.get(field.getTag())).containsKey(field.getIndicator())) {
                if (!overridePredicate) {
                    predicate = (String)indicatorMap.get(field.getIndicator());
                    fieldNames.put(field, predicate);
                }
                if ((subfields = (Map)params.get(predicate)) == null) {
                    subfields = defaultSubfields;
                }
            }
            if ((me = CatalogEntityWorker.subfieldDecoderMap(subfields, subfield)).getKey() != null && me.getValue() != null) {
                String fieldName;
                String v = me.getValue().toString();
                if (fieldNames.containsKey(field)) {
                    fieldName = (String)fieldNames.get(field);
                    List patterns = (List)params.get(fieldName + "pattern");
                    if (patterns != null) {
                        for (Map pattern : patterns) {
                            Map.Entry mme = pattern.entrySet().iterator().next();
                            String p = (String)mme.getKey();
                            String rel = (String)mme.getValue();
                            Matcher m = Pattern.compile(p, 2).matcher(v);
                            if (!m.matches()) continue;
                            v = rel;
                            break;
                        }
                    } else if (params.containsKey(me.getKey())) {
                        Map vm = (Map)params.get(me.getKey());
                        v = vm.containsKey(v) ? vm.get(v).toString() : v;
                    }
                } else {
                    fieldName = me.getKey();
                    if (params.containsKey(fieldName)) {
                        String vv;
                        Map vm = (Map)params.get(fieldName);
                        int pos = v.indexOf(32);
                        String string = vv = pos > 0 ? v.substring(0, pos) : v;
                        if (vm.containsKey(v)) {
                            v = (String)vm.get(v);
                        } else if (vm.containsKey(vv)) {
                            v = (String)vm.get(vv);
                        } else {
                            List patterns = (List)params.get(fieldName + "pattern");
                            if (patterns != null) {
                                for (Map pattern : patterns) {
                                    Map.Entry mme = pattern.entrySet().iterator().next();
                                    String p = (String)mme.getKey();
                                    String rel = (String)mme.getValue();
                                    Matcher m = Pattern.compile(p, 2).matcher(v);
                                    if (!m.matches()) continue;
                                    v = rel;
                                    break;
                                }
                            }
                        }
                    }
                }
                if (v != null) {
                    v = entity.transform(this, predicate, newResource, me.getKey(), v);
                }
                if (me.getKey().equals(predicate)) {
                    predicate = v;
                    overridePredicate = true;
                    continue;
                }
                newResource.add(me.getKey(), v);
                continue;
            }
            String subfieldId = subfield.getId();
            if (subfieldId.isEmpty()) {
                subfieldId = " ";
            }
            if (subfields.containsKey(subfieldId)) {
                String property = (String)subfields.get(subfieldId);
                newResource.add(property, entity.transform(this, predicate, newResource, property, subfield.getValue()));
                continue;
            }
            this.entityBuilder.unmapped(this.getWorkerState().getRecordIdentifier(), field, "field " + field + " missing definition for subfield '" + subfieldId + "' subfields=" + subfields);
        }
        resource.rename(tempPredicate, IRI.builder().curie(predicate).build());
        return newResource;
    }
}

