/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.catalog.entities.CatalogEntity;
import org.xbib.catalog.entities.CatalogEntityBuilder;
import org.xbib.catalog.entities.Facet;
import org.xbib.catalog.entities.Sequence;
import org.xbib.catalog.entities.YearFacet;
import org.xbib.catalog.entities.matching.endeavor.AuthoredWork;
import org.xbib.content.rdf.Literal;
import org.xbib.content.rdf.RdfContentBuilderProvider;
import org.xbib.content.rdf.RdfGraph;
import org.xbib.content.rdf.RdfGraphParams;
import org.xbib.content.rdf.Resource;
import org.xbib.content.rdf.internal.DefaultAnonymousResource;
import org.xbib.content.rdf.internal.DefaultLiteral;
import org.xbib.content.rdf.internal.DefaultRdfGraph;
import org.xbib.content.resource.IRI;

public class CatalogEntityWorkerState {
    private static final Logger logger = Logger.getLogger(CatalogEntityWorkerState.class.getName());
    private static final String LANGUAGE_FACET = "dc.language";
    private static final String DATE_FACET = "dc.date";
    private static final String TYPE_FACET = "dc.type";
    private static final String FORMAT_FACET = "dc.format";
    private final IRI itemIRI = IRI.create((String)"item");
    private final CatalogEntityBuilder builder;
    private final RdfGraph<RdfGraphParams> graph;
    private final Map<IRI, RdfContentBuilderProvider<?>> builders;
    private final Map<String, Facet<String>> facets;
    private final Map<String, Sequence<Resource>> sequences;
    private final String packageName;
    private final AuthoredWork authoredWorkKey;
    private String systemIdentifier;
    private String recordIdentifier;
    private String format;
    private String type;
    private String label;
    private String isil;
    private IRI uid;
    private Resource resource;

    public CatalogEntityWorkerState(CatalogEntityBuilder builder) {
        this.builder = builder;
        this.graph = new DefaultRdfGraph();
        this.builders = builder.contentBuilderProviders();
        this.packageName = builder.getPackageName();
        this.facets = new HashMap<String, Facet<String>>();
        this.sequences = new HashMap<String, Sequence<Resource>>();
        this.authoredWorkKey = new AuthoredWork();
    }

    public AuthoredWork getAuthoredWorkKey() {
        return this.authoredWorkKey;
    }

    public Map<String, Resource> getSerialsMap() {
        return this.builder.getSerialsMap();
    }

    public Map<String, Boolean> getMissingSerials() {
        return this.builder.getMissingSerials();
    }

    public String getLabel() {
        return this.label;
    }

    public CatalogEntityWorkerState setLabel(String label) {
        this.label = label;
        return this;
    }

    public String getRecordIdentifier() {
        return this.recordIdentifier;
    }

    public CatalogEntityWorkerState setRecordIdentifier(String recordIdentifier) {
        this.recordIdentifier = recordIdentifier;
        return this;
    }

    public Resource getResource() throws IOException {
        if (!this.graph.getResources().hasNext()) {
            this.resource = new DefaultAnonymousResource();
            this.graph.receive(this.resource);
        }
        return this.resource;
    }

    public Resource getResource(IRI predicate) throws IOException {
        if (!this.graph.hasResource(predicate)) {
            DefaultAnonymousResource resource = new DefaultAnonymousResource();
            this.graph.putResource(predicate, (Resource)resource);
        }
        return this.graph.getResource(predicate);
    }

    public Resource getNextItemResource() {
        if (this.graph.hasResource(this.itemIRI)) {
            Resource resource = this.graph.removeResource(this.itemIRI);
            resource.setId(this.uid != null ? this.uid : resource.id());
            this.graph.putResource(resource.id(), resource);
        }
        this.uid = null;
        DefaultAnonymousResource item = new DefaultAnonymousResource();
        this.graph.putResource(this.itemIRI, (Resource)item);
        return item;
    }

    public Iterator<Resource> getResourceIterator() {
        return this.graph.getResources();
    }

    public String getIdentifier() {
        return this.systemIdentifier;
    }

    public CatalogEntityWorkerState setIdentifier(String identifier) {
        this.systemIdentifier = identifier;
        return this;
    }

    public String getFormat() {
        return this.format;
    }

    public CatalogEntityWorkerState setFormat(String format) {
        this.format = format;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public CatalogEntityWorkerState setType(String type) {
        this.type = type;
        return this;
    }

    public String getISIL() {
        return this.isil;
    }

    public CatalogEntityWorkerState setISIL(String isil) {
        this.isil = isil;
        return this;
    }

    public IRI getUID() {
        return this.uid;
    }

    public CatalogEntityWorkerState setUID(IRI uid) {
        this.uid = uid;
        return this;
    }

    public Map<String, Facet<String>> getFacets() {
        return this.facets;
    }

    public Map<String, Sequence<Resource>> getSequences() {
        return this.sequences;
    }

    public void finish() throws IOException {
        Object entity;
        YearFacet dateFacet;
        CatalogEntity entity2;
        Facet<String> typeFacet;
        Facet<String> facet;
        CatalogEntity entity3;
        Facet<String> facet2;
        CatalogEntity catalogEntity;
        if (this.getResource().isDeleted()) {
            return;
        }
        if (this.graph.hasResource(this.itemIRI)) {
            Resource resource = this.graph.removeResource(this.itemIRI);
            resource.setId(this.uid != null ? this.uid : resource.id());
            this.graph.putResource(resource.id(), resource);
        }
        for (Sequence sequence : this.sequences.values()) {
            String sequenceName = sequence.getName();
            if (sequenceName == null) continue;
            String[] sequencePath = sequenceName.split("\\.");
            Resource resource = this.getResource();
            if (sequencePath.length > 1) {
                for (int i = 0; i < sequencePath.length - 1; ++i) {
                    resource = resource.newResource(IRI.builder().path(sequencePath[i]).build());
                }
            }
            sequenceName = sequencePath[sequencePath.length - 1];
            IRI predicate = IRI.builder().path(sequenceName).build();
            for (Resource resource2 : sequence.getResources()) {
                resource.add(predicate, resource2);
            }
        }
        this.sequences.clear();
        Facet<String> languageFacet = this.facets.get(LANGUAGE_FACET);
        if (languageFacet == null && (catalogEntity = this.builder.getEntitySpecification().getEntities().get(this.packageName + ".Language")) != null && (languageFacet = catalogEntity.getDefaultFacet()) != null) {
            this.facets.put(LANGUAGE_FACET, languageFacet);
        }
        if ((facet2 = this.facets.get(FORMAT_FACET)) == null && (entity3 = this.builder.getEntitySpecification().getEntities().get(this.packageName + ".FormatCarrier")) != null && (facet = entity3.getDefaultFacet()) != null) {
            this.facets.put(FORMAT_FACET, facet);
        }
        if ((typeFacet = this.facets.get(TYPE_FACET)) == null && (entity2 = this.builder.getEntitySpecification().getEntities().get(this.packageName + ".TypeMonograph")) != null && (typeFacet = entity2.getDefaultFacet()) != null) {
            this.facets.put(TYPE_FACET, typeFacet);
        }
        if ((dateFacet = (YearFacet)this.facets.get(DATE_FACET)) == null && (entity = this.builder.getEntitySpecification().getEntities().get(this.packageName + ".Date")) != null && (dateFacet = (YearFacet)((CatalogEntity)entity).getDefaultFacet()) != null) {
            this.facets.put(DATE_FACET, dateFacet);
        }
        for (Facet<String> facet3 : this.facets.values()) {
            String facetName = facet3.getName();
            if (facetName == null) continue;
            String[] stringArray = facetName.split("\\.");
            Resource resource = this.getResource();
            if (stringArray.length > 1) {
                for (int i = 0; i < stringArray.length - 1; ++i) {
                    resource = resource.newResource(IRI.builder().path(stringArray[i]).build());
                }
            }
            facetName = stringArray[stringArray.length - 1];
            IRI predicate = IRI.builder().path(facetName).build();
            for (String value : facet3.getValues()) {
                DefaultLiteral literal = new DefaultLiteral((Object)value).type(facet3.getType());
                try {
                    literal.object();
                    resource.add(predicate, (Literal)literal);
                }
                catch (NumberFormatException e) {
                    logger.log(Level.FINEST, e.getMessage(), e);
                }
            }
        }
        this.facets.clear();
        if (this.graph.getResources() != null) {
            Iterator it = this.graph.getResources();
            while (it.hasNext()) {
                Resource resource = (Resource)it.next();
                if (this.builders == null) continue;
                for (RdfContentBuilderProvider rdfContentBuilderProvider : this.builders.values()) {
                    rdfContentBuilderProvider.newContentBuilder().receive(resource);
                }
            }
        }
    }
}

