/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import org.xbib.catalog.entities.AbstractWorkerPool;
import org.xbib.catalog.entities.CatalogEntity;
import org.xbib.catalog.entities.CatalogEntitySpecification;
import org.xbib.catalog.entities.CatalogEntityWorker;
import org.xbib.catalog.entities.CatalogEntityWorkerState;
import org.xbib.catalog.entities.CatalogUnmappedEntityWorker;
import org.xbib.catalog.entities.Classifier;
import org.xbib.catalog.entities.IdentifierMapper;
import org.xbib.catalog.entities.StatusCodeMapper;
import org.xbib.catalog.entities.ValueMaps;
import org.xbib.catalog.entities.WorkerPool;
import org.xbib.catalog.entities.WorkerPoolListener;
import org.xbib.content.rdf.RdfContentBuilderProvider;
import org.xbib.content.rdf.Resource;
import org.xbib.content.resource.IRI;
import org.xbib.marc.Marc;
import org.xbib.marc.MarcField;
import org.xbib.marc.MarcListener;
import org.xbib.marc.MarcRecord;
import org.xbib.marc.MarcRecordListener;

public class CatalogEntityBuilder
extends AbstractWorkerPool<MarcRecord>
implements WorkerPool<MarcRecord>,
MarcListener,
MarcRecordListener,
Closeable {
    private static final Logger logger = Logger.getLogger(CatalogEntityBuilder.class.getName());
    private static final MarcRecord poison = MarcRecord.EMPTY;
    protected final Set<String> unmapped = Collections.synchronizedSet(new TreeSet());
    private final Map<String, Integer> mapped = Collections.synchronizedMap(new TreeMap());
    private final AtomicLong checksum = new AtomicLong();
    private final Set<String> invalid = Collections.synchronizedSet(new TreeSet());
    private final boolean isMapped;
    private CatalogEntitySpecification entitySpecification;
    private Marc.Builder marcBuilder;
    private IdentifierMapper identifierMapper;
    private StatusCodeMapper statusMapper;
    private Classifier classifier;
    private Map<String, Resource> serialsMap;
    private Map<String, Boolean> missingSerials;
    private boolean enableChecksum;
    private volatile boolean errorstate;

    public CatalogEntityBuilder(String packageName, URL url) throws IOException {
        this(packageName, Runtime.getRuntime().availableProcessors(), url, new HashMap<String, Object>(), true);
    }

    public CatalogEntityBuilder(String packageName, URL url, WorkerPoolListener<WorkerPool<MarcRecord>> listener) throws IOException {
        this(packageName, Runtime.getRuntime().availableProcessors(), url, new HashMap<String, Object>(), true, listener);
    }

    public CatalogEntityBuilder(String packageName, int workers, URL url) throws IOException {
        this(packageName, workers, url, new HashMap<String, Object>(), true);
    }

    public CatalogEntityBuilder(String packageName, int workers, URL url, WorkerPoolListener<WorkerPool<MarcRecord>> listener) throws IOException {
        this(packageName, workers, url, new HashMap<String, Object>(), true, listener);
    }

    public CatalogEntityBuilder(String packageName, URL url, boolean mapped) throws IOException {
        this(packageName, Runtime.getRuntime().availableProcessors(), url, new HashMap<String, Object>(), mapped);
    }

    public CatalogEntityBuilder(String packageName, int workers, URL url, boolean mapped) throws IOException {
        this(packageName, workers, url, new HashMap<String, Object>(), mapped);
    }

    public CatalogEntityBuilder(String packageName, int workers, URL url, Map<String, Object> params, boolean isMapped) throws IOException {
        this(packageName, workers, url, params, isMapped, null);
    }

    public CatalogEntityBuilder(String packageName, int workers, URL url, Map<String, Object> params, boolean isMapped, WorkerPoolListener<WorkerPool<MarcRecord>> listener) throws IOException {
        super(workers, listener);
        this.isMapped = isMapped;
        logger.log(Level.INFO, MessageFormat.format("workers:{1} mapped:{2} package:{0} spec:{3}", packageName, workers, isMapped, url));
        if (isMapped) {
            this.entitySpecification = new CatalogEntitySpecification(url, new HashMap<String, CatalogEntity>(), params, packageName);
            for (String key : this.entitySpecification.getMap().keySet()) {
                this.mapped.put(key, 0);
            }
            logger.log(Level.INFO, MessageFormat.format("spec: map of {0} field keys with {1} entities", this.entitySpecification.getMap().size(), this.entitySpecification.getEntities().size()));
            this.identifierMapper = this.setupIdentifierMapper(params);
            if (!this.identifierMapper.getMap().isEmpty()) {
                logger.log(Level.INFO, MessageFormat.format("identifier mapper: {0} entries", this.identifierMapper.getMap().size()));
            }
            this.statusMapper = this.setupStatusMapper(params);
            if (!this.statusMapper.getMap().isEmpty()) {
                logger.log(Level.INFO, MessageFormat.format("status mapper: {0} entries", this.statusMapper.getMap().size()));
            }
            this.serialsMap = this.setupSerialsMap(params);
            this.missingSerials = new HashMap<String, Boolean>();
        }
        this.open();
    }

    public CatalogEntitySpecification getEntitySpecification() {
        return this.entitySpecification;
    }

    public String getPackageName() {
        return this.entitySpecification != null ? this.entitySpecification.getPackageName() : null;
    }

    @Override
    public MarcRecord getPoison() {
        return poison;
    }

    public Map<IRI, RdfContentBuilderProvider<?>> contentBuilderProviders() {
        return new HashMap();
    }

    public boolean isEnableChecksum() {
        return this.enableChecksum;
    }

    public CatalogEntityBuilder setEnableChecksum(boolean enableChecksum) {
        this.enableChecksum = enableChecksum;
        return this;
    }

    public CatalogEntityBuilder addIdentifierMapper(String path) throws IOException {
        this.identifierMapper.load(this.getClass().getResource(path).openStream());
        return this;
    }

    public IdentifierMapper getIdentifierMapper() {
        return this.identifierMapper;
    }

    public CatalogEntityBuilder addStatusMapper(String path) throws IOException {
        this.statusMapper.load(path);
        return this;
    }

    public StatusCodeMapper getStatusMapper() {
        return this.statusMapper;
    }

    public CatalogEntityBuilder addClassifier(String prefix, String isil, String classifierPath) throws IOException {
        URL url;
        InputStream in;
        if (this.classifier == null) {
            this.classifier = new Classifier();
        }
        if ((in = (url = new URL(classifierPath)).openStream()) == null) {
            in = this.getClass().getResource(classifierPath).openStream();
        }
        this.classifier.load(in, isil, prefix);
        logger.log(Level.INFO, MessageFormat.format("added classifications for {0} with size of {1}", isil, this.classifier.getMap().size()));
        return this;
    }

    public Classifier getClassifier() {
        return this.classifier;
    }

    public Map<String, Resource> getSerialsMap() {
        return this.serialsMap;
    }

    public Map<String, Boolean> getMissingSerials() {
        return this.missingSerials;
    }

    protected void beforeFinishState(CatalogEntityWorkerState state) {
    }

    protected void afterFinishState(CatalogEntityWorkerState state) {
    }

    public void mapped(String id, MarcField marcField) {
        String k;
        this.mapped.put(k, this.mapped.containsKey(k = marcField.toKey()) ? this.mapped.get(k) + 1 : 1);
        k = marcField.toTagKey();
        this.mapped.put(k, this.mapped.containsKey(k) ? this.mapped.get(k) + 1 : 1);
    }

    public Map<String, Integer> getMapped() {
        return this.mapped;
    }

    public void unmapped(String id, MarcField marcField, String message) {
        String k = marcField.toKey();
        if (!this.unmapped.contains(k)) {
            logger.log(Level.WARNING, id + " : " + message);
            this.unmapped.add(k);
        }
    }

    public Set<String> getUnmapped() {
        return this.unmapped;
    }

    public void invalid(String id, MarcField marcField, String message) {
        String k = "\"" + marcField.toKey() + "\"";
        if (!this.invalid.contains(k)) {
            logger.log(Level.WARNING, id + " : " + message);
            this.invalid.add(k);
        }
    }

    public Set<String> getInvalid() {
        return this.invalid;
    }

    public void checksum(CRC32 crc32) {
        this.checksum.accumulateAndGet(crc32.getValue(), (n, m) -> n ^ m);
    }

    public long getChecksum() {
        return this.checksum.get();
    }

    public CatalogEntityWorker newWorker() {
        return this.isMapped ? new CatalogEntityWorker(this) : new CatalogUnmappedEntityWorker(this);
    }

    @Override
    public void close() {
        logger.info("closing");
        super.close();
        logger.info("closed");
    }

    public void beginCollection() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("beginCollection");
        }
    }

    public void beginRecord(String format, String type) {
        this.marcBuilder = Marc.builder().lightweightRecord().setFormat(format).setType(type);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("beginRecord format=" + format + " type=" + type);
        }
    }

    public void leader(String label) {
        this.marcBuilder.leader(label);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("leader=" + label);
        }
    }

    public void field(MarcField field) {
        this.marcBuilder.addField(field);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("field=" + field);
        }
    }

    public void endRecord() {
        this.record(this.marcBuilder.buildRecord());
    }

    public void record(MarcRecord marcRecord) {
        if (this.errorstate) {
            return;
        }
        try {
            this.submit(marcRecord);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            this.errorstate = true;
            this.close();
        }
    }

    public void endCollection() {
    }

    private IdentifierMapper setupIdentifierMapper(Map<String, Object> params) throws IOException {
        IdentifierMapper identifierMapper = new IdentifierMapper();
        ValueMaps valueMaps = new ValueMaps();
        Map<String, String> sigel2isil = valueMaps.getAssocStringMap("org/xbib/catalog/entities/mab/sigel2isil.json", "sigel2isil");
        identifierMapper.add(sigel2isil);
        if (params != null && params.containsKey("tab_sigel_url")) {
            URL url = new URL((String)params.get("tab_sigel_url"));
            logger.log(Level.INFO, MessageFormat.format("loading tab_sigel from {0}", url));
            identifierMapper.load(url.openStream());
            logger.log(Level.INFO, MessageFormat.format("sigel2isil size = {0}, plus tab_sigel = {1}", sigel2isil.size(), identifierMapper.getMap().size()));
        }
        return identifierMapper;
    }

    private StatusCodeMapper setupStatusMapper(Map<String, Object> params) throws IOException {
        StatusCodeMapper statusMapper = new StatusCodeMapper();
        ValueMaps valueMaps = new ValueMaps();
        Map<String, Object> statuscodes = valueMaps.getMap("org/xbib/catalog/entities/mab/status.json", "status");
        statusMapper.add(statuscodes);
        return statusMapper;
    }

    private Map<String, Resource> setupSerialsMap(Map<String, Object> params) {
        return null;
    }
}

