/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IdentifierMapper {
    private static final Logger logger = Logger.getLogger(IdentifierMapper.class.getName());
    private static final Pattern p = Pattern.compile("^1\\s(.{21})(.{5}).*");
    private final Map<String, String> map = new HashMap<String, String>();

    public Map<String, String> load(InputStream in) {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in, StandardCharsets.ISO_8859_1));){
            bufferedReader.lines().forEach(line -> {
                Matcher m;
                if (line.trim().length() > 0 && !line.startsWith("!") && (m = p.matcher((CharSequence)line)).matches()) {
                    String sigel = m.group(1).trim();
                    String owner = m.group(2).trim();
                    String isil = this.map.containsKey(sigel) ? this.map.get(sigel) : this.createISIL(sigel);
                    this.map.put(owner, isil);
                    this.map.put(sigel, isil);
                }
            });
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        return this.map;
    }

    private String createISIL(String sigel) {
        String isil = sigel;
        isil = isil.replaceAll("\u00e4", "ae").replaceAll("\u00f6", "oe").replaceAll("\u00fc", "ue").replaceAll("\\s+", "");
        if (!(isil = isil.replace('/', '-')).startsWith("ZDB")) {
            isil = "DE-" + isil;
        }
        return isil;
    }

    public IdentifierMapper add(String key, String value) {
        this.map.put(key, value);
        return this;
    }

    public IdentifierMapper add(Map<String, String> map) {
        this.map.putAll(map);
        return this;
    }

    public Map<String, String> getMap() {
        return this.map;
    }

    public String lookup(String value) {
        String s = this.map.containsKey(value) ? this.map.get(value) : value;
        return this.map.containsKey(s) ? this.map.get(s) : s;
    }
}

