/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities.mab;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xbib.catalog.entities.CatalogEntity;
import org.xbib.catalog.entities.CatalogEntityWorker;
import org.xbib.marc.MarcField;

public class TypeMediaSpecial
extends CatalogEntity {
    private static final Logger logger = Logger.getLogger(TypeMediaSpecial.class.getName());
    private String facet = "dc.format";
    private String predicate;
    private Map<Pattern, String> patterns;

    public TypeMediaSpecial(Map<String, Object> params) {
        super(params);
        Map regexes;
        if (params.containsKey("_facet")) {
            this.facet = params.get("_facet").toString();
        }
        this.predicate = this.getClass().getSimpleName();
        if (params.containsKey("_predicate")) {
            this.predicate = params.get("_predicate").toString();
        }
        if ((regexes = (Map)this.getParams().get("regexes")) != null) {
            this.patterns = new HashMap<Pattern, String>();
            for (Map.Entry entry : regexes.entrySet()) {
                String key = (String)entry.getKey();
                this.patterns.put(Pattern.compile(Pattern.quote(key), 2), (String)regexes.get(key));
            }
        }
    }

    @Override
    public CatalogEntity transform(CatalogEntityWorker worker, MarcField field) throws IOException {
        String value = ((MarcField.Subfield)field.getSubfields().getFirst()).getValue();
        if (!value.isEmpty()) {
            List<String> list = this.findCodes(value);
            if (list.isEmpty()) {
                logger.log(Level.WARNING, MessageFormat.format("no media type detected from value: \"{0}\" in field {1}", value, field));
            }
            for (String code : list) {
                worker.getWorkerState().getResource().add(this.predicate, code);
                this.facetize(worker, code);
            }
        }
        return null;
    }

    private List<String> findCodes(String value) {
        LinkedList<String> list = new LinkedList<String>();
        Map rak = (Map)this.getParams().get("rak");
        if (rak != null && rak.containsKey(value)) {
            list.add((String)rak.get(value));
        }
        if (this.patterns != null) {
            for (Map.Entry<Pattern, String> entry : this.patterns.entrySet()) {
                String v;
                Pattern p = entry.getKey();
                Matcher m = p.matcher(value);
                if (!m.find() || (v = this.patterns.get(p)) == null) continue;
                list.add(v);
            }
        }
        return list;
    }

    @Override
    protected String getFacetName() {
        return this.facet;
    }
}

