/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities.marc.bib;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.catalog.entities.CatalogEntity;
import org.xbib.catalog.entities.CatalogEntityWorker;
import org.xbib.marc.MarcField;

public class GeneralInformation
extends CatalogEntity {
    private static final Logger logger = Logger.getLogger(GeneralInformation.class.getName());
    private Map<String, Object> codes;

    public GeneralInformation(Map<String, Object> params) {
        super(params);
        this.codes = (Map)params.get("codes");
    }

    @Override
    public CatalogEntity transform(CatalogEntityWorker worker, MarcField field) throws IOException {
        String value = this.getValue(field);
        if (value.length() != 40) {
            logger.log(Level.WARNING, "broken GeneralInformation field, length is not 40");
        }
        String date1 = value.length() > 11 ? value.substring(7, 11) : "0000";
        worker.getWorkerState().getResource().add("date1", this.check(date1));
        String date2 = value.length() > 15 ? value.substring(11, 15) : "0000";
        worker.getWorkerState().getResource().add("date2", this.check(date2));
        for (int i = 0; i < value.length(); ++i) {
            Map q;
            String ch = value.substring(i, i + 1);
            if ("|".equals(ch) || " ".equals(ch) || this.codes == null || (q = (Map)this.codes.get(Integer.toString(i))) == null) continue;
            String predicate = (String)q.get("_predicate");
            if (predicate == null) {
                logger.log(Level.WARNING, MessageFormat.format("no predicate set, code {0}, field {1}", ch, field));
                continue;
            }
            String code = (String)q.get(ch);
            if (code == null) {
                logger.log(Level.WARNING, MessageFormat.format("unmapped code {0} in field {1} predicate {2}", ch, field, predicate));
            }
            worker.getWorkerState().getResource().add(predicate, code);
        }
        return super.transform(worker, field);
    }

    private Integer check(String date) {
        try {
            int d = Integer.parseInt(date);
            if (d == 9999) {
                return null;
            }
            return d;
        }
        catch (Exception e) {
            logger.log(Level.FINEST, e.getMessage(), e);
            return null;
        }
    }
}

