/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities.matching.string;

import java.util.LinkedHashMap;
import java.util.Map;
import org.xbib.catalog.entities.matching.string.EncoderException;
import org.xbib.catalog.entities.matching.string.StringEncoder;

public class WordBoundaryEntropyEncoder
implements StringEncoder {
    @Override
    public String encode(String s) throws EncoderException {
        LinkedHashMap<Character, Integer> freq = new LinkedHashMap<Character, Integer>();
        char[] chars = s.toLowerCase().toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (i == 0 || i > 0 && chars[i - 1] == ' ' || i + 1 == chars.length) {
                ch = Character.toUpperCase(ch);
            }
            freq.put(Character.valueOf(ch), freq.containsKey(Character.valueOf(ch)) ? (Integer)freq.get(Character.valueOf(ch)) + 1 : 0);
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : freq.entrySet()) {
            char ch = ((Character)entry.getKey()).charValue();
            if (Character.isWhitespace(ch) || (Integer)entry.getValue() >= 2) continue;
            sb.append(ch);
        }
        return sb.toString();
    }
}

