/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities.mab;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.xbib.catalog.entities.CatalogEntity;
import org.xbib.catalog.entities.CatalogEntityWorker;
import org.xbib.catalog.entities.CatalogEntityWorkerState;
import org.xbib.catalog.entities.Classifier;
import org.xbib.catalog.entities.ClassifierEntry;
import org.xbib.catalog.entities.IdentifierMapper;
import org.xbib.catalog.entities.TermFacet;
import org.xbib.catalog.entities.ValueMapper;
import org.xbib.content.rdf.Literal;
import org.xbib.content.rdf.Resource;
import org.xbib.content.resource.IRI;
import org.xbib.marc.MarcField;

public class Item
extends CatalogEntity {
    private static final String taxonomyFacet = "xbib.taxonomy";
    private static final String identifierFacet = "xbib.identifier";

    public Item(Map<String, Object> params) {
        super(params);
    }

    @Override
    public CatalogEntity transform(CatalogEntityWorker worker, MarcField field) throws IOException {
        worker.append(worker.getWorkerState().getNextItemResource(), field, this);
        return null;
    }

    @Override
    public String transform(CatalogEntityWorker worker, String predicate, Resource resource, String property, String value) {
        block8: {
            List codes;
            Map<String, Object> map;
            ValueMapper mapper;
            block9: {
                String doc;
                String isil;
                Collection<ClassifierEntry> entries;
                CatalogEntityWorkerState state;
                block7: {
                    String isil2;
                    state = worker.getWorkerState();
                    if (!"identifier".equals(property)) break block7;
                    IdentifierMapper mapper2 = worker.getIdentifierMapper();
                    if (mapper2 != null && (isil2 = mapper2.lookup(value)) != null) {
                        String doc2;
                        Collection<ClassifierEntry> entries2;
                        Classifier classifier;
                        resource.add("identifier", isil2);
                        state.setUID(IRI.builder().curie(isil2).build());
                        state.setISIL(isil2);
                        state.getFacets().putIfAbsent(identifierFacet, new TermFacet().setName(identifierFacet).setType(Literal.STRING));
                        TermFacet holderFacet = state.getFacets().get(identifierFacet);
                        holderFacet.addValue(isil2);
                        int pos = isil2.lastIndexOf(45);
                        if (isil2.indexOf(45) < pos) {
                            holderFacet.addValue(isil2.substring(0, pos));
                        }
                        if ((classifier = worker.getClassifier()) != null && (entries2 = classifier.lookup(isil2, doc2 = state.getRecordIdentifier(), value, null)) != null) {
                            for (ClassifierEntry classifierEntry : entries2) {
                                String facet = "xbib.taxonomy." + isil2 + ".notation";
                                state.getFacets().putIfAbsent(facet, new TermFacet().setName(facet).setType(Literal.STRING));
                                state.getFacets().get(facet).addValue(classifierEntry.getCode());
                                facet = "xbib.taxonomy." + isil2 + ".text";
                                state.getFacets().putIfAbsent(facet, new TermFacet().setName(facet).setType(Literal.STRING));
                                state.getFacets().get(facet).addValue(classifierEntry.getText());
                            }
                        }
                        return isil2;
                    }
                    break block8;
                }
                if (!"callnumber".equals(property)) break block9;
                state.setUID(IRI.builder().curie(state.getISIL() + "/" + value).build());
                Classifier classifier = worker.getClassifier();
                if (classifier == null || (entries = classifier.lookup(isil = state.getISIL(), doc = state.getRecordIdentifier(), value, null)) == null) break block8;
                for (ClassifierEntry classifierEntry : entries) {
                    String facet = "xbib.taxonomy." + isil + ".notation";
                    state.getFacets().putIfAbsent(facet, new TermFacet().setName(facet).setType(Literal.STRING));
                    state.getFacets().get(facet).addValue(classifierEntry.getCode());
                    facet = "xbib.taxonomy." + isil + ".text";
                    state.getFacets().putIfAbsent(facet, new TermFacet().setName(facet).setType(Literal.STRING));
                    state.getFacets().get(facet).addValue(classifierEntry.getText());
                }
                break block8;
            }
            if ("status".equals(property) && (mapper = worker.getValueMapper()) != null && (map = mapper.getMap("status")).containsKey(value) && (codes = (List)map.get(value)) != null) {
                for (String code : codes) {
                    resource.add("interlibraryservice", code);
                }
            }
        }
        return value;
    }
}

