/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities.mab;

import java.util.Map;
import org.xbib.catalog.entities.CatalogEntity;
import org.xbib.catalog.entities.CatalogEntityWorker;
import org.xbib.catalog.entities.IdentifierMapper;
import org.xbib.content.rdf.Resource;

public class Person
extends CatalogEntity {
    public Person(Map<String, Object> params) {
        super(params);
    }

    @Override
    public String transform(CatalogEntityWorker worker, String predicate, Resource resource, String property, String value) {
        String isil;
        IdentifierMapper mapper;
        if ("personIdentifier".equals(property)) {
            resource.add("personIdentifier", value);
            if (value.startsWith("(DE-588)")) {
                resource.add("identifierGND", value.substring(8));
            } else if (value.startsWith("(DE-101)")) {
                resource.add("identifierDNB", value.substring(8));
            } else if (value.startsWith("(DE-600)")) {
                resource.add("identifierZDB", value.substring(8).replaceAll("\\-", "").toLowerCase());
                return value.replaceAll("\\-", "").toLowerCase();
            }
            return null;
        }
        if ("source".equals(property) && (mapper = worker.getIdentifierMapper()) != null && (isil = mapper.lookup(value)) != null) {
            resource.add("personSource", isil);
            return null;
        }
        return value.replaceAll("<<(.*?)>>", "\u0098$1\u009c").replaceAll("<(.*?)>", "[$1]").replaceAll("\u00ac(.*?)\u00ac", "\u0098$1\u009c");
    }
}

