/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities.mab;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.xbib.catalog.entities.CatalogEntity;
import org.xbib.catalog.entities.CatalogEntityWorker;
import org.xbib.catalog.entities.CatalogEntityWorkerState;
import org.xbib.catalog.entities.TermFacet;
import org.xbib.content.rdf.Literal;
import org.xbib.marc.MarcField;

public class Language
extends CatalogEntity {
    private static final String FACET_NAME = "dc.language";

    public Language(Map<String, Object> params) {
        super(params);
    }

    @Override
    public CatalogEntity transform(CatalogEntityWorker worker, MarcField field) throws IOException {
        super.transform(worker, field);
        this.facetize(worker, field.getValue());
        for (MarcField.Subfield subfield : field.getSubfields()) {
            this.facetize(worker, subfield.getValue());
        }
        return this;
    }

    @Override
    protected void facetize(CatalogEntityWorker worker, String value) {
        String verbose;
        CatalogEntityWorkerState state = worker.getWorkerState();
        state.getFacets().putIfAbsent(this.getFacetName(), new TermFacet().setName(this.getFacetName()).setType(Literal.STRING));
        TermFacet languageFacet = state.getFacets().get(this.getFacetName());
        Map languages = (Map)this.getParams().get("language");
        if (languages == null) {
            return;
        }
        if (value != null && (verbose = (String)languages.get(value.toLowerCase(Locale.ROOT))) != null) {
            languageFacet.addValue(verbose);
        }
    }

    @Override
    protected String getFacetName() {
        return FACET_NAME;
    }
}

