/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.catalog.entities.matching.digits;

import java.text.NumberFormat;
import java.util.LinkedList;
import java.util.List;

public class RunLengthEncoder {
    private final List<Number> members = new LinkedList<Number>();
    private final NumberFormat format = NumberFormat.getInstance();

    public RunLengthEncoder member(Number number) {
        this.members.add(number);
        return this;
    }

    public String encode() {
        StringBuilder sb = new StringBuilder();
        for (Number o : this.members) {
            if (o instanceof Number) {
                Number number = o;
                String s = this.format.format(number);
                if (s.length() <= 9) {
                    sb.append(Integer.toString(s.length())).append(s);
                    continue;
                }
                throw new IllegalArgumentException("number too long");
            }
            sb.append(o.toString());
        }
        return sb.toString();
    }
}

