/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.xbib.graphics.chart.ChartTitle;
import org.xbib.graphics.chart.axis.Axis;
import org.xbib.graphics.chart.axis.AxisPair;
import org.xbib.graphics.chart.axis.Direction;
import org.xbib.graphics.chart.io.BitmapFormat;
import org.xbib.graphics.chart.io.VectorGraphicsFormat;
import org.xbib.graphics.chart.io.vector.EPSGraphics2D;
import org.xbib.graphics.chart.io.vector.PDFGraphics2D;
import org.xbib.graphics.chart.io.vector.ProcessingPipeline;
import org.xbib.graphics.chart.io.vector.SVGGraphics2D;
import org.xbib.graphics.chart.legend.Legend;
import org.xbib.graphics.chart.plot.Plot;
import org.xbib.graphics.chart.series.Series;
import org.xbib.graphics.chart.style.Styler;

public abstract class Chart<ST extends Styler, S extends Series> {
    protected final ST styler;
    protected final ChartTitle<ST, S> chartTitle;
    protected final Map<String, S> seriesMap;
    protected AxisPair<?, ?> axisPair;
    protected Plot<ST, S> plot;
    protected Legend<ST, S> legend;
    private int width;
    private int height;
    private String title = "";
    private String xAxisTitle = "";
    private String yAxisTitle = "";
    private final Map<Integer, String> yAxisGroupTitleMap;

    protected Chart(int width, int height, ST styler) {
        this.styler = styler;
        this.width = width;
        this.height = height;
        this.chartTitle = new ChartTitle(this);
        this.seriesMap = new LinkedHashMap<String, S>();
        this.yAxisGroupTitleMap = new HashMap<Integer, String>();
    }

    public abstract void paint(Graphics2D var1, int var2, int var3);

    protected void paintBackground(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, ((Styler)this.styler).getAntiAlias() ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setColor(((Styler)this.styler).getChartBackgroundColor());
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight());
        g.fill(rect);
    }

    public List<Double> listFromDoubleArray(double[] data) {
        if (data == null) {
            return null;
        }
        ArrayList<Double> dataNumber = new ArrayList<Double>();
        for (double d : data) {
            dataNumber.add(d);
        }
        return dataNumber;
    }

    public List<Double> listFromFloatArray(float[] data) {
        if (data == null) {
            return null;
        }
        ArrayList<Double> dataNumber = new ArrayList<Double>();
        for (float f : data) {
            dataNumber.add(Double.valueOf(f));
        }
        return dataNumber;
    }

    public List<Double> listFromIntArray(int[] data) {
        if (data == null) {
            return null;
        }
        ArrayList<Double> dataNumber = new ArrayList<Double>();
        int[] nArray = data;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            double d = nArray[i];
            dataNumber.add(d);
        }
        return dataNumber;
    }

    public List<Double> getGeneratedData(int length) {
        ArrayList<Double> generatedData = new ArrayList<Double>();
        for (int i = 1; i < length + 1; ++i) {
            generatedData.add(Double.valueOf(i));
        }
        return generatedData;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getXAxisTitle() {
        return this.xAxisTitle;
    }

    public void setXAxisTitle(String xAxisTitle) {
        this.xAxisTitle = xAxisTitle;
    }

    public String getyYAxisTitle() {
        return this.yAxisTitle;
    }

    public void setYAxisTitle(String yAxisTitle) {
        this.yAxisTitle = yAxisTitle;
    }

    public String getYAxisGroupTitle(int yAxisGroup) {
        String title = this.yAxisGroupTitleMap.get(yAxisGroup);
        if (title == null) {
            return this.yAxisTitle;
        }
        return title;
    }

    public void setYAxisGroupTitle(int yAxisGroup, String yAxisTitle) {
        this.yAxisGroupTitleMap.put(yAxisGroup, yAxisTitle);
    }

    public void setXAxisLabelOverrideMap(Map<Double, Object> overrideMap) {
        this.axisPair.getAxisLabelOverrideMap().put("X0", overrideMap);
    }

    public void setYAxisLabelOverrideMap(Map<Double, Object> overrideMap) {
        this.axisPair.getAxisLabelOverrideMap().put("Y0", overrideMap);
    }

    public void setYAxisLabelOverrideMap(Map<Double, Object> overrideMap, int yAxisGroup) {
        this.axisPair.getAxisLabelOverrideMap().put("Y" + yAxisGroup, overrideMap);
    }

    public Map<Double, Object> getYAxisLabelOverrideMap(Direction direction, int yIndex) {
        Map<String, Map<Double, Object>> axisLabelOverrideMap = this.axisPair.getAxisLabelOverrideMap();
        return axisLabelOverrideMap.get(direction.name() + yIndex);
    }

    public ChartTitle<ST, S> getChartTitle() {
        return this.chartTitle;
    }

    public Legend<ST, S> getLegend() {
        return this.legend;
    }

    public Plot<ST, S> getPlot() {
        return this.plot;
    }

    public Axis<?, ?> getXAxis() {
        return this.axisPair.getXAxis();
    }

    public Axis<?, ?> getYAxis() {
        return this.axisPair.getYAxis();
    }

    public Axis<?, ?> getYAxis(int yIndex) {
        return this.axisPair.getYAxis(yIndex);
    }

    public AxisPair<?, ?> getAxisPair() {
        return this.axisPair;
    }

    public Map<String, S> getSeriesMap() {
        return this.seriesMap;
    }

    public S removeSeries(String seriesName) {
        return (S)((Series)this.seriesMap.remove(seriesName));
    }

    public ST getStyler() {
        return this.styler;
    }

    public Format getXAxisFormat() {
        return this.axisPair.getXAxis().getAxisTickCalculator().getAxisFormat();
    }

    public Format getYAxisFormat() {
        return this.axisPair.getYAxis().getAxisTickCalculator().getAxisFormat();
    }

    public void saveBitmap(OutputStream outputStream, BitmapFormat bitmapFormat) throws IOException {
        BufferedImage bufferedImage = this.getBufferedImage();
        ImageIO.write((RenderedImage)bufferedImage, bitmapFormat.toString().toLowerCase(), outputStream);
        outputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveBitmapWithDPI(OutputStream outputStream, BitmapFormat bitmapFormat, int dpi) throws IOException {
        double scaleFactor = (double)dpi / 72.0;
        BufferedImage bufferedImage = new BufferedImage((int)((double)this.getWidth() * scaleFactor), (int)((double)this.getHeight() * scaleFactor), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        AffineTransform at = graphics2D.getTransform();
        at.scale(scaleFactor, scaleFactor);
        graphics2D.setTransform(at);
        this.paint(graphics2D, this.getWidth(), this.getHeight());
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(bitmapFormat.toString().toLowerCase());
        if (writers.hasNext()) {
            ImageWriter writer = writers.next();
            ImageWriteParam iwp = writer.getDefaultWriteParam();
            ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(1);
            IIOMetadata metadata = writer.getDefaultImageMetadata(typeSpecifier, iwp);
            if (metadata.isReadOnly() || !metadata.isStandardMetadataFormatSupported()) {
                throw new IllegalArgumentException("It is not possible to set the DPI on a bitmap with " + bitmapFormat + " format!! Try another format.");
            }
            Chart.setDPI(metadata, dpi);
            try {
                writer.setOutput(outputStream);
                IIOImage image = new IIOImage(bufferedImage, null, metadata);
                writer.write(null, image, iwp);
            }
            finally {
                writer.dispose();
            }
        }
    }

    private static void setDPI(IIOMetadata metadata, int DPI) throws IIOInvalidTreeException {
        double dotsPerMilli = 1.0 * (double)DPI / 10.0 / 2.54;
        IIOMetadataNode horiz = new IIOMetadataNode("HorizontalPixelSize");
        horiz.setAttribute("value", Double.toString(dotsPerMilli));
        IIOMetadataNode vert = new IIOMetadataNode("VerticalPixelSize");
        vert.setAttribute("value", Double.toString(dotsPerMilli));
        IIOMetadataNode dim = new IIOMetadataNode("Dimension");
        dim.appendChild(horiz);
        dim.appendChild(vert);
        IIOMetadataNode root = new IIOMetadataNode("javax_imageio_1.0");
        root.appendChild(dim);
        metadata.mergeTree("javax_imageio_1.0", root);
    }

    public void saveJPGWithQuality(OutputStream outputStream, float quality) throws IOException {
        BufferedImage bufferedImage = this.getBufferedImage();
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
        ImageWriter writer = iter.next();
        ImageWriteParam iwp = writer.getDefaultWriteParam();
        iwp.setCompressionMode(2);
        iwp.setCompressionQuality(quality);
        try (OutputStream outputStream2 = outputStream;){
            writer.setOutput(outputStream);
            IIOImage image = new IIOImage(bufferedImage, null, null);
            writer.write(null, image, iwp);
            writer.dispose();
        }
    }

    public byte[] getBitmapBytes(BitmapFormat bitmapFormat) throws IOException {
        BufferedImage bufferedImage = this.getBufferedImage();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, bitmapFormat.toString().toLowerCase(), baos);
        baos.flush();
        byte[] imageInBytes = baos.toByteArray();
        baos.close();
        return imageInBytes;
    }

    public BufferedImage getBufferedImage() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.paint(graphics2D, this.getWidth(), this.getHeight());
        return bufferedImage;
    }

    public void write(OutputStream outputStream, VectorGraphicsFormat vectorGraphicsFormat) throws IOException {
        ProcessingPipeline g = null;
        switch (vectorGraphicsFormat) {
            case EPS: {
                g = new EPSGraphics2D(0.0, 0.0, this.getWidth(), this.getHeight());
                break;
            }
            case PDF: {
                g = new PDFGraphics2D(0.0, 0.0, this.getWidth(), this.getHeight());
                break;
            }
            case SVG: {
                g = new SVGGraphics2D(0.0, 0.0, this.getWidth(), this.getHeight());
                break;
            }
        }
        this.paint(g, this.getWidth(), this.getHeight());
        if (outputStream != null) {
            outputStream.write(g.getBytes());
        }
    }
}

