/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart;

import java.util.List;
import org.xbib.graphics.chart.theme.Theme;
import org.xbib.graphics.chart.xy.XYChart;
import org.xbib.graphics.chart.xy.XYSeries;
import org.xbib.graphics.chart.xy.XYStyler;

public final class QuickChart {
    private static final int WIDTH = 600;
    private static final int HEIGHT = 400;

    private QuickChart() {
    }

    public static XYChart getChart(String chartTitle, String xTitle, String yTitle, String seriesName, double[] xData, double[] yData) {
        double[][] yData2d = new double[][]{yData};
        if (seriesName == null) {
            return QuickChart.getChart(chartTitle, xTitle, yTitle, null, xData, yData2d);
        }
        return QuickChart.getChart(chartTitle, xTitle, yTitle, new String[]{seriesName}, xData, yData2d);
    }

    public static XYChart getChart(String chartTitle, String xTitle, String yTitle, String[] seriesNames, double[] xData, double[][] yData) {
        XYChart chart = new XYChart(600, 400);
        chart.setTitle(chartTitle);
        chart.setXAxisTitle(xTitle);
        chart.setYAxisTitle(yTitle);
        for (int i = 0; i < yData.length; ++i) {
            XYSeries series;
            if (seriesNames != null) {
                series = chart.addSeries(seriesNames[i], xData, yData[i]);
            } else {
                ((XYStyler)chart.getStyler()).setLegendVisible(false);
                series = chart.addSeries(" " + i, xData, yData[i]);
            }
            series.setMarker(Theme.Series.NONE_MARKER);
        }
        return chart;
    }

    public static XYChart getChart(String chartTitle, String xTitle, String yTitle, String seriesName, List<? extends Double> xData, List<? extends Double> yData) {
        XYChart chart = new XYChart(600, 400);
        chart.setTitle(chartTitle);
        chart.setXAxisTitle(xTitle);
        chart.setYAxisTitle(yTitle);
        XYSeries series = chart.addSeries(seriesName, xData, yData);
        series.setMarker(Theme.Series.NONE_MARKER);
        return chart;
    }
}

