/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.axis;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.List;
import java.util.Map;
import org.xbib.graphics.chart.Chart;
import org.xbib.graphics.chart.ChartComponent;
import org.xbib.graphics.chart.axis.AxisTick;
import org.xbib.graphics.chart.axis.AxisTickCalculator;
import org.xbib.graphics.chart.axis.AxisTickCalculatorCategory;
import org.xbib.graphics.chart.axis.AxisTickCalculatorInstant;
import org.xbib.graphics.chart.axis.AxisTickCalculatorLogarithmic;
import org.xbib.graphics.chart.axis.AxisTickCalculatorNumber;
import org.xbib.graphics.chart.axis.AxisTickCalculatorOverride;
import org.xbib.graphics.chart.axis.AxisTitle;
import org.xbib.graphics.chart.axis.DataType;
import org.xbib.graphics.chart.axis.Direction;
import org.xbib.graphics.chart.axis.YAxisPosition;
import org.xbib.graphics.chart.category.CategoryStyler;
import org.xbib.graphics.chart.legend.LegendPosition;
import org.xbib.graphics.chart.series.AxesChartSeries;
import org.xbib.graphics.chart.series.AxesChartSeriesCategory;
import org.xbib.graphics.chart.style.AxesChartStyler;
import org.xbib.graphics.chart.style.Styler;

public class Axis<ST extends AxesChartStyler, S extends AxesChartSeries>
implements ChartComponent {
    private final Chart<ST, S> chart;
    private final Rectangle2D.Double bounds;
    private final ST axesChartStyler;
    private final AxisTitle<ST, S> axisTitle;
    private final AxisTick<ST, S> axisTick;
    private final Direction direction;
    private final int yIndex;
    private DataType dataType;
    private AxisTickCalculator axisTickCalculator;
    private double min;
    private double max;

    public Axis(Chart<ST, S> chart, Direction direction, int yIndex) {
        this.chart = chart;
        this.axesChartStyler = (AxesChartStyler)chart.getStyler();
        this.direction = direction;
        this.yIndex = yIndex;
        this.bounds = new Rectangle2D.Double();
        this.axisTitle = new AxisTitle<ST, S>(chart, direction, direction == Direction.Y ? this : null, yIndex);
        this.axisTick = new AxisTick<ST, S>(chart, direction, direction == Direction.Y ? this : null);
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }

    public void resetMinMax() {
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
    }

    public void addMinMax(double min, double max) {
        if (Double.isNaN(this.min) || min < this.min) {
            this.min = min;
        }
        if (max > this.max) {
            this.max = max;
        }
    }

    public void preparePaint() {
        if (this.direction == Direction.Y) {
            double height;
            double xOffset = 0.0;
            double yOffset = this.chart.getChartTitle().getBounds().getHeight() + (double)((Styler)this.axesChartStyler).getChartPadding();
            int i = 1;
            double width = 60.0;
            do {
                double approximateXAxisWidth = (double)this.chart.getWidth() - width - (((Styler)this.axesChartStyler).getLegendPosition() == LegendPosition.OutsideE ? this.chart.getLegend().getBounds().getWidth() : 0.0) - (double)(2 * ((Styler)this.axesChartStyler).getChartPadding()) - (double)(((AxesChartStyler)this.axesChartStyler).isYAxisTicksVisible() ? ((AxesChartStyler)this.axesChartStyler).getPlotMargin() : 0) - (double)(((Styler)this.axesChartStyler).getLegendPosition() == LegendPosition.OutsideE && ((Styler)this.axesChartStyler).isLegendVisible() ? ((Styler)this.axesChartStyler).getChartPadding() : 0);
                height = (double)this.chart.getHeight() - yOffset - this.chart.getXAxis().getXAxisHeightHint(approximateXAxisWidth) - (double)((AxesChartStyler)this.axesChartStyler).getPlotMargin() - (double)((Styler)this.axesChartStyler).getChartPadding() - (((Styler)this.axesChartStyler).getLegendPosition() == LegendPosition.OutsideS ? this.chart.getLegend().getBounds().getHeight() : 0.0);
                width = this.getYAxisWidthHint(height);
            } while (i-- > 0);
            this.bounds.setRect(xOffset, yOffset, width, height);
        } else {
            Rectangle2D.Double leftYAxisBounds = this.chart.getAxisPair().getLeftYAxisBounds();
            Rectangle2D.Double rightYAxisBounds = this.chart.getAxisPair().getRightYAxisBounds();
            double maxYAxisY = Math.max(((RectangularShape)leftYAxisBounds).getY() + ((RectangularShape)leftYAxisBounds).getHeight(), ((RectangularShape)rightYAxisBounds).getY() + ((RectangularShape)rightYAxisBounds).getHeight());
            double xOffset = ((RectangularShape)leftYAxisBounds).getWidth() + (double)((Styler)this.axesChartStyler).getChartPadding();
            double yOffset = maxYAxisY + (double)((AxesChartStyler)this.axesChartStyler).getPlotMargin() - (((Styler)this.axesChartStyler).getLegendPosition() == LegendPosition.OutsideS ? this.chart.getLegend().getBounds().getHeight() : 0.0);
            double legendWidth = 0.0;
            if (((Styler)this.axesChartStyler).getLegendPosition() == LegendPosition.OutsideE && ((Styler)this.axesChartStyler).isLegendVisible()) {
                legendWidth = this.chart.getLegend().getBounds().getWidth() + (double)((Styler)this.axesChartStyler).getChartPadding();
            }
            double width = (double)this.chart.getWidth() - ((RectangularShape)leftYAxisBounds).getWidth() - ((RectangularShape)rightYAxisBounds).getWidth() - (double)(2 * ((Styler)this.axesChartStyler).getChartPadding()) - legendWidth;
            double height = (double)this.chart.getHeight() - maxYAxisY - (double)((Styler)this.axesChartStyler).getChartPadding() - (double)((AxesChartStyler)this.axesChartStyler).getPlotMargin();
            this.bounds.setRect(xOffset, yOffset, width, height);
        }
    }

    @Override
    public void paint(Graphics2D g) {
        Object oldHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.direction == Direction.Y) {
            boolean onRight;
            boolean bl = onRight = ((Styler)this.axesChartStyler).getYAxisGroupPosistion(this.yIndex) == YAxisPosition.Right;
            if (onRight) {
                this.axisTick.paint(g);
                this.axisTitle.paint(g);
            } else {
                this.axisTitle.paint(g);
                this.axisTick.paint(g);
            }
            this.bounds.width = (((AxesChartStyler)this.axesChartStyler).isYAxisTitleVisible() ? this.axisTitle.getBounds().getWidth() : 0.0) + this.axisTick.getBounds().getWidth();
        } else {
            this.axisTickCalculator = this.getAxisTickCalculator(this.bounds.getWidth());
            this.axisTitle.paint(g);
            this.axisTick.paint(g);
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
    }

    private double getXAxisHeightHint(double workingSpace) {
        double titleHeight = 0.0;
        if (this.chart.getXAxisTitle() != null && !this.chart.getXAxisTitle().trim().equalsIgnoreCase("") && ((AxesChartStyler)this.axesChartStyler).isXAxisTitleVisible()) {
            TextLayout textLayout = new TextLayout(this.chart.getXAxisTitle(), ((AxesChartStyler)this.axesChartStyler).getAxisTitleFont(), new FontRenderContext(null, true, false));
            Rectangle2D rectangle = textLayout.getBounds();
            titleHeight = rectangle.getHeight() + (double)((AxesChartStyler)this.chart.getStyler()).getAxisTitlePadding();
        }
        this.axisTickCalculator = this.getAxisTickCalculator(workingSpace);
        double axisTickLabelsHeight = 0.0;
        if (((AxesChartStyler)this.chart.getStyler()).isXAxisTicksVisible()) {
            String sampleLabel = "";
            for (int i = 0; i < this.axisTickCalculator.getTickLabels().size(); ++i) {
                if (this.axisTickCalculator.getTickLabels().get(i) == null || this.axisTickCalculator.getTickLabels().get(i).length() <= sampleLabel.length()) continue;
                sampleLabel = this.axisTickCalculator.getTickLabels().get(i);
            }
            TextLayout textLayout = new TextLayout(sampleLabel.length() == 0 ? " " : sampleLabel, ((AxesChartStyler)this.axesChartStyler).getAxisTickLabelsFont(), new FontRenderContext(null, true, false));
            AffineTransform rot = ((AxesChartStyler)this.axesChartStyler).getXAxisLabelRotation() == 0 ? null : AffineTransform.getRotateInstance(-1.0 * Math.toRadians(((AxesChartStyler)this.axesChartStyler).getXAxisLabelRotation()));
            Shape shape = textLayout.getOutline(rot);
            Rectangle rectangle = shape.getBounds();
            axisTickLabelsHeight = ((RectangularShape)rectangle).getHeight() + (double)((AxesChartStyler)this.axesChartStyler).getAxisTickPadding() + (double)((AxesChartStyler)this.axesChartStyler).getAxisTickMarkLength();
        }
        return titleHeight + axisTickLabelsHeight;
    }

    private double getYAxisWidthHint(double workingSpace) {
        double titleHeight = 0.0;
        if (this.chart.getyYAxisTitle() != null && !this.chart.getyYAxisTitle().trim().equalsIgnoreCase("") && ((AxesChartStyler)this.axesChartStyler).isYAxisTitleVisible()) {
            TextLayout textLayout = new TextLayout(this.chart.getyYAxisTitle(), ((AxesChartStyler)this.axesChartStyler).getAxisTitleFont(), new FontRenderContext(null, true, false));
            Rectangle2D rectangle = textLayout.getBounds();
            titleHeight = rectangle.getHeight() + (double)((AxesChartStyler)this.axesChartStyler).getAxisTitlePadding();
        }
        double axisTickLabelsHeight = 0.0;
        if (((AxesChartStyler)this.axesChartStyler).isYAxisTicksVisible()) {
            this.axisTickCalculator = this.getAxisTickCalculator(workingSpace);
            String sampleLabel = "";
            for (int i = 0; i < this.axisTickCalculator.getTickLabels().size(); ++i) {
                if (this.axisTickCalculator.getTickLabels().get(i) == null || this.axisTickCalculator.getTickLabels().get(i).length() <= sampleLabel.length()) continue;
                sampleLabel = this.axisTickCalculator.getTickLabels().get(i);
            }
            TextLayout textLayout = new TextLayout(sampleLabel.length() == 0 ? " " : sampleLabel, ((AxesChartStyler)this.axesChartStyler).getAxisTickLabelsFont(), new FontRenderContext(null, true, false));
            Rectangle2D rectangle = textLayout.getBounds();
            axisTickLabelsHeight = rectangle.getWidth() + (double)((AxesChartStyler)this.axesChartStyler).getAxisTickPadding() + (double)((AxesChartStyler)this.axesChartStyler).getAxisTickMarkLength();
        }
        return titleHeight + axisTickLabelsHeight;
    }

    private AxisTickCalculator getAxisTickCalculator(double workingSpace) {
        Map<Double, Object> labelOverrideMap = this.chart.getYAxisLabelOverrideMap(this.getDirection(), this.yIndex);
        if (labelOverrideMap != null) {
            if (this.getDirection() == Direction.X && this.axesChartStyler instanceof CategoryStyler) {
                AxesChartSeriesCategory axesChartSeries = (AxesChartSeriesCategory)this.chart.getSeriesMap().values().iterator().next();
                List categories = (List)axesChartSeries.getXData();
                DataType axisType = this.chart.getAxisPair().getXAxis().getDataType();
                return new AxisTickCalculatorOverride(this.getDirection(), workingSpace, (AxesChartStyler)this.axesChartStyler, labelOverrideMap, axisType, categories.size());
            }
            return new AxisTickCalculatorOverride(this.getDirection(), workingSpace, this.min, this.max, (AxesChartStyler)this.axesChartStyler, labelOverrideMap);
        }
        if (this.getDirection() == Direction.X) {
            if (this.axesChartStyler instanceof CategoryStyler) {
                AxesChartSeriesCategory axesChartSeries = (AxesChartSeriesCategory)this.chart.getSeriesMap().values().iterator().next();
                List categories = (List)axesChartSeries.getXData();
                DataType axisType = this.chart.getAxisPair().getXAxis().getDataType();
                return new AxisTickCalculatorCategory(this.getDirection(), workingSpace, categories, axisType, (AxesChartStyler)this.axesChartStyler);
            }
            if (this.getDataType() == DataType.Instant) {
                return new AxisTickCalculatorInstant(this.getDirection(), workingSpace, this.min, this.max, (AxesChartStyler)this.axesChartStyler);
            }
            if (((AxesChartStyler)this.axesChartStyler).isXAxisLogarithmic()) {
                return new AxisTickCalculatorLogarithmic(this.getDirection(), workingSpace, this.min, this.max, (AxesChartStyler)this.axesChartStyler);
            }
            return new AxisTickCalculatorNumber(this.getDirection(), workingSpace, this.min, this.max, (AxesChartStyler)this.axesChartStyler);
        }
        if (((AxesChartStyler)this.axesChartStyler).isYAxisLogarithmic() && this.getDataType() != DataType.Instant) {
            return new AxisTickCalculatorLogarithmic(this.getDirection(), workingSpace, this.min, this.max, (AxesChartStyler)this.axesChartStyler);
        }
        return new AxisTickCalculatorNumber(this.getDirection(), workingSpace, this.min, this.max, (AxesChartStyler)this.axesChartStyler);
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        if (dataType != null && this.dataType != null && this.dataType != dataType) {
            throw new IllegalArgumentException("Different Axes (e.g. Date, Number, String) cannot be mixed on the same chart!!");
        }
        this.dataType = dataType;
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public AxisTick<ST, S> getAxisTick() {
        return this.axisTick;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public AxisTitle<ST, S> getAxisTitle() {
        return this.axisTitle;
    }

    public AxisTickCalculator getAxisTickCalculator() {
        return this.axisTickCalculator;
    }

    public int getYIndex() {
        return this.yIndex;
    }
}

