/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.axis;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.xbib.graphics.chart.Chart;
import org.xbib.graphics.chart.ChartComponent;
import org.xbib.graphics.chart.axis.Axis;
import org.xbib.graphics.chart.axis.Direction;
import org.xbib.graphics.chart.axis.YAxisPosition;
import org.xbib.graphics.chart.category.CategorySeriesRenderStyle;
import org.xbib.graphics.chart.category.CategoryStyler;
import org.xbib.graphics.chart.legend.LegendPosition;
import org.xbib.graphics.chart.series.AxesChartSeries;
import org.xbib.graphics.chart.series.AxesChartSeriesCategory;
import org.xbib.graphics.chart.style.AxesChartStyler;

public class AxisPair<ST extends AxesChartStyler, S extends AxesChartSeries>
implements ChartComponent {
    private final Chart<ST, S> chart;
    private final Axis<ST, S> xAxis;
    private final Axis<ST, S> yAxis;
    private final TreeMap<Integer, Axis<ST, S>> yAxisMap;
    private final Rectangle2D.Double leftYAxisBounds;
    private final Rectangle2D.Double rightYAxisBounds;
    private Axis<ST, S> leftMainYAxis;
    private Axis<ST, S> rightMainYAxis;
    private final Map<String, Map<Double, Object>> axisLabelOverrideMap;

    public AxisPair(Chart<ST, S> chart) {
        this.chart = chart;
        this.xAxis = new Axis<ST, S>(chart, Direction.X, 0);
        this.yAxis = new Axis<ST, S>(chart, Direction.Y, 0);
        this.yAxisMap = new TreeMap();
        this.yAxisMap.put(0, this.yAxis);
        this.leftYAxisBounds = new Rectangle2D.Double();
        this.rightYAxisBounds = new Rectangle2D.Double();
        this.axisLabelOverrideMap = new HashMap<String, Map<Double, Object>>();
    }

    @Override
    public Rectangle2D getBounds() {
        return null;
    }

    @Override
    public void paint(Graphics2D g) {
        Rectangle2D.Double bounds;
        double rightEnd;
        this.prepareForPaint();
        this.leftMainYAxis = null;
        this.rightMainYAxis = null;
        AxesChartStyler styler = (AxesChartStyler)this.chart.getStyler();
        int chartPadding = styler.getChartPadding();
        int tickMargin = styler.isYAxisTicksVisible() ? styler.getPlotMargin() : 0;
        this.leftYAxisBounds.width = 0.0;
        int leftCount = 0;
        double leftStart = chartPadding;
        for (Map.Entry<Integer, Axis<ST, S>> e : this.yAxisMap.entrySet()) {
            Axis<ST, S> ya = e.getValue();
            if (styler.getYAxisGroupPosistion(e.getKey()) == YAxisPosition.Right || e.getKey() == 0) continue;
            ya.preparePaint();
            Rectangle2D.Double bounds2 = (Rectangle2D.Double)ya.getBounds();
            bounds2.x = leftStart;
            ya.paint(g);
            double width = bounds2.getWidth();
            leftStart += (double)chartPadding + width + (double)tickMargin;
            this.leftYAxisBounds.width += width;
            ++leftCount;
            this.leftMainYAxis = ya;
        }
        if (styler.getYAxisGroupPosistion(0) != YAxisPosition.Right) {
            this.yAxis.preparePaint();
            Rectangle2D.Double bounds3 = (Rectangle2D.Double)this.yAxis.getBounds();
            bounds3.x = leftStart;
            this.yAxis.paint(g);
            double width = bounds3.getWidth();
            this.leftYAxisBounds.width += width;
            ++leftCount;
            this.leftMainYAxis = this.yAxis;
        }
        if (leftCount > 1) {
            this.leftYAxisBounds.width += (double)((leftCount - 1) * chartPadding);
        }
        this.leftYAxisBounds.width += (double)(leftCount * tickMargin);
        this.rightYAxisBounds.width = 0.0;
        double legendWidth = 0.0;
        if (styler.getLegendPosition() == LegendPosition.OutsideE && styler.isLegendVisible()) {
            legendWidth = this.chart.getLegend().getBounds().getWidth() + (double)styler.getChartPadding();
        }
        this.rightYAxisBounds.x = rightEnd = (double)this.chart.getWidth() - legendWidth - (double)chartPadding;
        int rightCount = 0;
        for (Map.Entry e : this.yAxisMap.descendingMap().entrySet()) {
            double xOffset;
            Axis ya = (Axis)e.getValue();
            if (styler.getYAxisGroupPosistion((Integer)e.getKey()) != YAxisPosition.Right || (Integer)e.getKey() == 0) continue;
            ya.preparePaint();
            Rectangle2D.Double bounds4 = (Rectangle2D.Double)ya.getBounds();
            double aproxWidth = bounds4.getWidth();
            bounds4.x = xOffset = rightEnd - aproxWidth;
            this.rightYAxisBounds.x = xOffset;
            ya.paint(g);
            this.rightYAxisBounds.width += aproxWidth;
            rightEnd -= (double)chartPadding + aproxWidth + (double)tickMargin;
            ++rightCount;
            this.rightMainYAxis = ya;
        }
        if (styler.getYAxisGroupPosistion(0) == YAxisPosition.Right) {
            double xOffset;
            this.yAxis.preparePaint();
            bounds = (Rectangle2D.Double)this.yAxis.getBounds();
            double aproxWidth = bounds.getWidth();
            bounds.x = xOffset = rightEnd - aproxWidth;
            this.rightYAxisBounds.x = xOffset;
            this.yAxis.paint(g);
            this.rightYAxisBounds.width += aproxWidth;
            ++rightCount;
            this.rightMainYAxis = this.yAxis;
        }
        if (this.leftMainYAxis == null) {
            this.leftMainYAxis = this.yAxis;
        }
        if (this.rightMainYAxis == null) {
            this.rightMainYAxis = this.yAxis;
        }
        if (rightCount > 1) {
            this.rightYAxisBounds.width += (double)((rightCount - 1) * chartPadding);
        }
        this.rightYAxisBounds.width += (double)(rightCount * tickMargin);
        bounds = (Rectangle2D.Double)this.yAxis.getBounds();
        this.leftYAxisBounds.x = chartPadding;
        this.leftYAxisBounds.y = bounds.y;
        this.leftYAxisBounds.height = bounds.height;
        this.rightYAxisBounds.y = bounds.y;
        this.rightYAxisBounds.height = bounds.height;
        this.xAxis.preparePaint();
        this.xAxis.paint(g);
    }

    public Axis<ST, S> getYAxis(int yIndex) {
        return this.yAxisMap.get(yIndex);
    }

    public Axis<ST, S> getXAxis() {
        return this.xAxis;
    }

    public Axis<ST, S> getYAxis() {
        return this.yAxis;
    }

    public Rectangle2D.Double getLeftYAxisBounds() {
        return this.leftYAxisBounds;
    }

    public Rectangle2D.Double getRightYAxisBounds() {
        return this.rightYAxisBounds;
    }

    public Axis<ST, S> getLeftMainYAxis() {
        return this.leftMainYAxis;
    }

    public Axis<ST, S> getRightMainYAxis() {
        return this.rightMainYAxis;
    }

    public Map<String, Map<Double, Object>> getAxisLabelOverrideMap() {
        return this.axisLabelOverrideMap;
    }

    private void prepareForPaint() {
        boolean mainYAxisUsed = false;
        if (this.chart.getSeriesMap() != null) {
            for (AxesChartSeries series : this.chart.getSeriesMap().values()) {
                int n = series.getYAxisGroup();
                if (!mainYAxisUsed && n == 0) {
                    mainYAxisUsed = true;
                }
                if (this.yAxisMap.containsKey(n)) continue;
                this.yAxisMap.put(n, new Axis<ST, S>(this.chart, Direction.Y, n));
            }
        }
        this.xAxis.setDataType(null);
        this.yAxis.setDataType(null);
        for (AxesChartSeries series : this.chart.getSeriesMap().values()) {
            this.xAxis.setDataType(series.getxAxisDataType());
            this.yAxis.setDataType(series.getyAxisDataType());
            this.getYAxis(series.getYAxisGroup()).setDataType(series.getyAxisDataType());
            if (mainYAxisUsed) continue;
            this.yAxis.setDataType(series.getyAxisDataType());
        }
        this.xAxis.resetMinMax();
        for (Axis<ST, S> ya : this.yAxisMap.values()) {
            ya.resetMinMax();
        }
        if (this.chart.getSeriesMap() == null || this.chart.getSeriesMap().size() < 1) {
            this.xAxis.addMinMax(-1.0, 1.0);
            for (Axis<ST, S> ya : this.yAxisMap.values()) {
                ya.addMinMax(-1.0, 1.0);
            }
        } else {
            int disabledCount = 0;
            for (AxesChartSeries axesChartSeries : this.chart.getSeriesMap().values()) {
                if (!axesChartSeries.isEnabled()) {
                    ++disabledCount;
                    continue;
                }
                this.xAxis.addMinMax(axesChartSeries.getXMin(), axesChartSeries.getXMax());
                this.getYAxis(axesChartSeries.getYAxisGroup()).addMinMax(axesChartSeries.getYMin(), axesChartSeries.getYMax());
                if (mainYAxisUsed) continue;
                this.yAxis.addMinMax(axesChartSeries.getYMin(), axesChartSeries.getYMax());
            }
            if (disabledCount == this.chart.getSeriesMap().values().size()) {
                this.xAxis.addMinMax(-1.0, 1.0);
                for (Axis axis : this.yAxisMap.values()) {
                    axis.addMinMax(-1.0, 1.0);
                }
            }
        }
        this.overrideMinMaxForXAxis();
        for (Axis<ST, S> ya : this.yAxisMap.values()) {
            this.overrideMinMaxForYAxis(ya);
        }
        if (((AxesChartStyler)this.chart.getStyler()).isXAxisLogarithmic() && this.xAxis.getMin() <= 0.0) {
            throw new IllegalArgumentException("Series data (accounting for error bars too) cannot be less or equal to zero for a logarithmic X-Axis");
        }
        if (((AxesChartStyler)this.chart.getStyler()).isYAxisLogarithmic() && this.yAxis.getMin() <= 0.0) {
            for (Axis<ST, S> ya : this.yAxisMap.values()) {
                if (!(ya.getMin() <= 0.0)) continue;
                throw new IllegalArgumentException("Series data (accounting for error bars too) cannot be less or equal to zero for a logarithmic Y-Axis");
            }
        }
        if (this.xAxis.getMin() == Double.POSITIVE_INFINITY || this.xAxis.getMax() == Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException("Series data (accounting for error bars too) cannot be equal to Double.POSITIVE_INFINITY!!!");
        }
        for (Axis<ST, S> ya : this.yAxisMap.values()) {
            if (ya.getMin() == Double.POSITIVE_INFINITY || ya.getMax() == Double.POSITIVE_INFINITY) {
                throw new IllegalArgumentException("Series data (accounting for error bars too) cannot be equal to Double.POSITIVE_INFINITY!!!");
            }
            if (ya.getMin() != Double.NEGATIVE_INFINITY && ya.getMax() != Double.NEGATIVE_INFINITY) continue;
            throw new IllegalArgumentException("Series data (accounting for error bars too) cannot be equal to Double.NEGATIVE_INFINITY!!!");
        }
        if (this.xAxis.getMin() == Double.NEGATIVE_INFINITY || this.xAxis.getMax() == Double.NEGATIVE_INFINITY) {
            throw new IllegalArgumentException("Series data (accounting for error bars too) cannot be equal to Double.NEGATIVE_INFINITY!!!");
        }
    }

    private void overrideMinMaxForXAxis() {
        double overrideXAxisMinValue = this.xAxis.getMin();
        double overrideXAxisMaxValue = this.xAxis.getMax();
        if (((AxesChartStyler)this.chart.getStyler()).getXAxisMin() != null) {
            overrideXAxisMinValue = ((AxesChartStyler)this.chart.getStyler()).getXAxisMin();
        }
        if (((AxesChartStyler)this.chart.getStyler()).getXAxisMax() != null) {
            overrideXAxisMaxValue = ((AxesChartStyler)this.chart.getStyler()).getXAxisMax();
        }
        this.xAxis.setMin(overrideXAxisMinValue);
        this.xAxis.setMax(overrideXAxisMaxValue);
    }

    private void overrideMinMaxForYAxis(Axis<?, ?> yAxis) {
        CategoryStyler categoryStyler;
        double overrideYAxisMinValue = yAxis.getMin();
        double overrideYAxisMaxValue = yAxis.getMax();
        if (this.chart.getStyler() instanceof CategoryStyler && (categoryStyler = (CategoryStyler)this.chart.getStyler()).getDefaultSeriesRenderStyle() == CategorySeriesRenderStyle.Bar) {
            if (categoryStyler.isStacked()) {
                AxesChartSeriesCategory axesChartSeries = (AxesChartSeriesCategory)this.chart.getSeriesMap().values().iterator().next();
                List categories = (List)axesChartSeries.getXData();
                int numCategories = categories.size();
                double[] accumulatedStackOffsetPos = new double[numCategories];
                double[] accumulatedStackOffsetNeg = new double[numCategories];
                for (AxesChartSeries series : this.chart.getSeriesMap().values()) {
                    AxesChartSeriesCategory axesChartSeriesCategory = (AxesChartSeriesCategory)series;
                    if (!series.isEnabled()) continue;
                    int categoryCounter = 0;
                    for (Number number : axesChartSeriesCategory.getYData()) {
                        if (number == null) {
                            ++categoryCounter;
                            continue;
                        }
                        if (number.doubleValue() > 0.0) {
                            int n = categoryCounter;
                            accumulatedStackOffsetPos[n] = accumulatedStackOffsetPos[n] + number.doubleValue();
                        } else if (number.doubleValue() < 0.0) {
                            int n = categoryCounter;
                            accumulatedStackOffsetNeg[n] = accumulatedStackOffsetNeg[n] + number.doubleValue();
                        }
                        ++categoryCounter;
                    }
                }
                double max = accumulatedStackOffsetPos[0];
                for (int i = 1; i < accumulatedStackOffsetPos.length; ++i) {
                    if (!(accumulatedStackOffsetPos[i] > max)) continue;
                    max = accumulatedStackOffsetPos[i];
                }
                double min = accumulatedStackOffsetNeg[0];
                for (int i = 1; i < accumulatedStackOffsetNeg.length; ++i) {
                    if (!(accumulatedStackOffsetNeg[i] < min)) continue;
                    min = accumulatedStackOffsetNeg[i];
                }
                overrideYAxisMaxValue = max;
                overrideYAxisMinValue = min;
            }
            if (yAxis.getMin() > 0.0) {
                overrideYAxisMinValue = 0.0;
            }
            if (yAxis.getMax() < 0.0) {
                overrideYAxisMaxValue = 0.0;
            }
        }
        if (((AxesChartStyler)this.chart.getStyler()).getYAxisMin(yAxis.getYIndex()) != null) {
            overrideYAxisMinValue = ((AxesChartStyler)this.chart.getStyler()).getYAxisMin(yAxis.getYIndex());
        } else if (((AxesChartStyler)this.chart.getStyler()).getYAxisMin() != null) {
            overrideYAxisMinValue = ((AxesChartStyler)this.chart.getStyler()).getYAxisMin();
        }
        if (((AxesChartStyler)this.chart.getStyler()).getYAxisMax(yAxis.getYIndex()) != null) {
            overrideYAxisMaxValue = ((AxesChartStyler)this.chart.getStyler()).getYAxisMax(yAxis.getYIndex());
        } else if (((AxesChartStyler)this.chart.getStyler()).getYAxisMax() != null) {
            overrideYAxisMaxValue = ((AxesChartStyler)this.chart.getStyler()).getYAxisMax();
        }
        yAxis.setMin(overrideYAxisMinValue);
        yAxis.setMax(overrideYAxisMaxValue);
    }
}

