/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.axis;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.xbib.graphics.chart.Chart;
import org.xbib.graphics.chart.ChartComponent;
import org.xbib.graphics.chart.axis.Axis;
import org.xbib.graphics.chart.axis.AxisTickLabels;
import org.xbib.graphics.chart.axis.AxisTickMarks;
import org.xbib.graphics.chart.axis.Direction;
import org.xbib.graphics.chart.series.AxesChartSeries;
import org.xbib.graphics.chart.style.AxesChartStyler;

public class AxisTick<ST extends AxesChartStyler, S extends AxesChartSeries>
implements ChartComponent {
    private final Chart<ST, S> chart;
    private final Direction direction;
    private Rectangle2D bounds;
    private final AxisTickLabels<ST, S> axisTickLabels;
    private final AxisTickMarks<ST, S> axisTickMarks;

    protected AxisTick(Chart<ST, S> chart, Direction direction, Axis<ST, S> yAxis) {
        this.chart = chart;
        this.direction = direction;
        this.axisTickLabels = new AxisTickLabels<ST, S>(chart, direction, yAxis);
        this.axisTickMarks = new AxisTickMarks<ST, S>(chart, direction, yAxis);
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }

    @Override
    public void paint(Graphics2D g) {
        if (this.direction == Direction.Y && ((AxesChartStyler)this.chart.getStyler()).isYAxisTicksVisible()) {
            this.axisTickLabels.paint(g);
            this.axisTickMarks.paint(g);
            this.bounds = new Rectangle2D.Double(this.axisTickLabels.getBounds().getX(), this.axisTickLabels.getBounds().getY(), this.axisTickLabels.getBounds().getWidth() + (double)((AxesChartStyler)this.chart.getStyler()).getAxisTickPadding() + this.axisTickMarks.getBounds().getWidth(), this.axisTickMarks.getBounds().getHeight());
        } else if (this.direction == Direction.X && ((AxesChartStyler)this.chart.getStyler()).isXAxisTicksVisible()) {
            this.axisTickLabels.paint(g);
            this.axisTickMarks.paint(g);
            this.bounds = new Rectangle2D.Double(this.axisTickMarks.getBounds().getX(), this.axisTickMarks.getBounds().getY(), this.axisTickLabels.getBounds().getWidth(), this.axisTickMarks.getBounds().getHeight() + (double)((AxesChartStyler)this.chart.getStyler()).getAxisTickPadding() + this.axisTickLabels.getBounds().getHeight());
        } else {
            this.bounds = new Rectangle2D.Double();
        }
    }

    protected AxisTickLabels<ST, S> getAxisTickLabels() {
        return this.axisTickLabels;
    }
}

