/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.axis;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.RectangularShape;
import java.text.Format;
import java.util.LinkedList;
import java.util.List;
import org.xbib.graphics.chart.axis.Direction;
import org.xbib.graphics.chart.style.AxesChartStyler;

public abstract class AxisTickCalculator {
    protected final Direction axisDirection;
    protected final double workingSpace;
    protected final double minValue;
    protected final double maxValue;
    protected final AxesChartStyler styler;
    protected Format axisFormat;
    protected List<Double> tickLocations = new LinkedList<Double>();
    protected List<String> tickLabels = new LinkedList<String>();

    public AxisTickCalculator(Direction axisDirection, double workingSpace, double minValue, double maxValue, AxesChartStyler styler) {
        this.axisDirection = axisDirection;
        this.workingSpace = workingSpace;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.styler = styler;
    }

    public double getFirstPosition(double gridStep) {
        return this.minValue - this.minValue % gridStep - gridStep;
    }

    public List<Double> getTickLocations() {
        return this.tickLocations;
    }

    public List<String> getTickLabels() {
        return this.tickLabels;
    }

    public boolean willLabelsFitInTickSpaceHint(List<String> tickLabels, int tickSpacingHint) {
        if (this.axisDirection == Direction.Y) {
            return true;
        }
        String sampleLabel = " ";
        for (String tickLabel : tickLabels) {
            if (tickLabel == null || tickLabel.length() <= sampleLabel.length()) continue;
            sampleLabel = tickLabel;
        }
        TextLayout textLayout = new TextLayout(sampleLabel, this.styler.getAxisTickLabelsFont(), new FontRenderContext(null, true, false));
        AffineTransform rot = this.styler.getXAxisLabelRotation() == 0 ? null : AffineTransform.getRotateInstance(-1.0 * Math.toRadians(this.styler.getXAxisLabelRotation()));
        Shape shape = textLayout.getOutline(rot);
        Rectangle rectangle = shape.getBounds();
        double largestLabelWidth = ((RectangularShape)rectangle).getWidth();
        return largestLabelWidth * 1.1 < (double)tickSpacingHint;
    }

    public Format getAxisFormat() {
        return this.axisFormat;
    }
}

