/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.axis;

import java.math.BigDecimal;
import java.util.List;
import org.xbib.graphics.chart.axis.AxisTickCalculator;
import org.xbib.graphics.chart.axis.DataType;
import org.xbib.graphics.chart.axis.Direction;
import org.xbib.graphics.chart.formatter.DateFormatter;
import org.xbib.graphics.chart.formatter.NumberFormatter;
import org.xbib.graphics.chart.formatter.StringFormatter;
import org.xbib.graphics.chart.style.AxesChartStyler;

public class AxisTickCalculatorCategory
extends AxisTickCalculator {
    public AxisTickCalculatorCategory(Direction axisDirection, double workingSpace, List<?> categories, DataType axisType, AxesChartStyler styler) {
        super(axisDirection, workingSpace, Double.NaN, Double.NaN, styler);
        this.calculate(categories, axisType);
    }

    private void calculate(List<?> categories, DataType axisType) {
        double tickSpace = this.styler.getPlotContentSize() * this.workingSpace;
        double margin = (this.workingSpace - tickSpace) / 2.0;
        double gridStep = tickSpace / (double)categories.size();
        double firstPosition = gridStep / 2.0;
        if (axisType == DataType.String) {
            this.axisFormat = new StringFormatter();
        } else if (axisType == DataType.Number) {
            this.axisFormat = new NumberFormatter(this.styler, this.axisDirection, this.minValue, this.maxValue);
        } else if (axisType == DataType.Instant) {
            this.axisFormat = new DateFormatter(this.styler.getDatePattern(), this.styler.getLocale());
        }
        int counter = 0;
        for (Object category : categories) {
            if (axisType == DataType.String) {
                this.tickLabels.add(category.toString());
            } else if (axisType == DataType.Number) {
                this.tickLabels.add(this.axisFormat.format(new BigDecimal(category.toString()).doubleValue()));
            } else if (axisType == DataType.Instant) {
                this.tickLabels.add(this.axisFormat.format(category));
            }
            double tickLabelPosition = (int)(margin + firstPosition + gridStep * (double)counter++);
            this.tickLocations.add(tickLabelPosition);
        }
    }
}

