/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.axis;

import java.math.BigDecimal;
import org.xbib.graphics.chart.axis.AxisTickCalculator;
import org.xbib.graphics.chart.axis.Direction;
import org.xbib.graphics.chart.formatter.NumberLogFormatter;
import org.xbib.graphics.chart.style.AxesChartStyler;

public class AxisTickCalculatorLogarithmic
extends AxisTickCalculator {
    private final NumberLogFormatter numberLogFormatter;

    public AxisTickCalculatorLogarithmic(Direction axisDirection, double workingSpace, double minValue, double maxValue, AxesChartStyler styler) {
        super(axisDirection, workingSpace, minValue, maxValue, styler);
        this.numberLogFormatter = new NumberLogFormatter(styler, axisDirection);
        this.axisFormat = this.numberLogFormatter;
        this.calculate();
    }

    private void calculate() {
        if (this.minValue == this.maxValue) {
            this.tickLabels.add(this.numberLogFormatter.format(BigDecimal.valueOf(this.maxValue)));
            this.tickLocations.add(this.workingSpace / 2.0);
            return;
        }
        double tickSpace = this.styler.getPlotContentSize() * this.workingSpace;
        if (tickSpace < (double)this.styler.getXAxisTickMarkSpacingHint()) {
            return;
        }
        double margin = (this.workingSpace - tickSpace) / 2.0;
        int logMin = (int)Math.floor(Math.log10(this.minValue));
        int logMax = (int)Math.ceil(Math.log10(this.maxValue));
        double firstPosition = AxisTickCalculatorLogarithmic.pow(logMin);
        double tickStep = AxisTickCalculatorLogarithmic.pow(logMin - 1);
        for (int i = logMin; i <= logMax; ++i) {
            for (double j = firstPosition; j <= AxisTickCalculatorLogarithmic.pow(i) + 1.0E-8; j += tickStep) {
                if (j < this.minValue - tickStep) continue;
                if (j > this.maxValue + tickStep) break;
                if (Math.abs(Math.log10(j) % 1.0) < 1.0E-8) {
                    this.tickLabels.add(this.numberLogFormatter.format(j));
                } else {
                    this.tickLabels.add(null);
                }
                double tickLabelPosition = (int)(margin + (Math.log10(j) - Math.log10(this.minValue)) / (Math.log10(this.maxValue) - Math.log10(this.minValue)) * tickSpace);
                this.tickLocations.add(tickLabelPosition);
            }
            firstPosition = (tickStep *= AxisTickCalculatorLogarithmic.pow(1)) + AxisTickCalculatorLogarithmic.pow(i);
        }
    }

    private static double pow(int exponent) {
        return exponent > 0 ? Math.pow(10.0, exponent) : 1.0 / Math.pow(10.0, -1 * exponent);
    }
}

