/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.axis;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.xbib.graphics.chart.axis.AxisTickCalculator;
import org.xbib.graphics.chart.axis.Direction;
import org.xbib.graphics.chart.formatter.NumberFormatter;
import org.xbib.graphics.chart.style.AxesChartStyler;

public class AxisTickCalculatorNumber
extends AxisTickCalculator {
    private final NumberFormatter numberFormatter;

    public AxisTickCalculatorNumber(Direction axisDirection, double workingSpace, double minValue, double maxValue, AxesChartStyler styler) {
        super(axisDirection, workingSpace, minValue, maxValue, styler);
        this.numberFormatter = new NumberFormatter(styler, axisDirection, minValue, maxValue);
        this.axisFormat = this.numberFormatter;
        this.calculate();
    }

    private void calculate() {
        int gridStepInChartSpace;
        if (this.minValue == this.maxValue) {
            this.tickLabels.add(this.numberFormatter.format(BigDecimal.valueOf(this.maxValue)));
            this.tickLocations.add(this.workingSpace / 2.0);
            return;
        }
        double tickSpace = this.styler.getPlotContentSize() * this.workingSpace;
        if (tickSpace < (double)this.styler.getXAxisTickMarkSpacingHint()) {
            return;
        }
        double margin = (this.workingSpace - tickSpace) / 2.0;
        double span = Math.abs(Math.min(this.maxValue - this.minValue, Double.MAX_VALUE));
        int tickSpacingHint = (this.axisDirection == Direction.X ? this.styler.getXAxisTickMarkSpacingHint() : this.styler.getYAxisTickMarkSpacingHint()) - 5;
        if (this.axisDirection == Direction.Y && tickSpace < 160.0) {
            tickSpacingHint = 20;
        }
        do {
            BigDecimal cleanedFirstPosition;
            this.tickLabels.clear();
            this.tickLocations.clear();
            double significand = span / tickSpace * (double)(tickSpacingHint += 5);
            int exponent = 0;
            if (significand == 0.0) {
                exponent = 1;
            } else if (significand < 1.0) {
                while (significand < 1.0) {
                    significand *= 10.0;
                    --exponent;
                }
            } else {
                while (significand >= 10.0 || significand == Double.NEGATIVE_INFINITY) {
                    significand /= 10.0;
                    ++exponent;
                }
            }
            double gridStep = significand > 7.5 ? 10.0 * AxisTickCalculatorNumber.pow(exponent) : (significand > 3.5 ? 5.0 * AxisTickCalculatorNumber.pow(exponent) : (significand > 1.5 ? 2.0 * AxisTickCalculatorNumber.pow(exponent) : AxisTickCalculatorNumber.pow(exponent)));
            gridStepInChartSpace = (int)(gridStep / span * tickSpace);
            BigDecimal gridStepBigDecimal = BigDecimal.valueOf(gridStep);
            BigDecimal cleanedGridStep = gridStepBigDecimal.setScale(10, RoundingMode.HALF_UP).stripTrailingZeros();
            BigDecimal firstPosition = BigDecimal.valueOf(this.getFirstPosition(cleanedGridStep.doubleValue()));
            BigDecimal value = cleanedFirstPosition = firstPosition.setScale(10, RoundingMode.HALF_UP).stripTrailingZeros();
            while (value.compareTo(BigDecimal.valueOf(this.maxValue + 2.0 * cleanedGridStep.doubleValue())) < 0) {
                String tickLabel = this.numberFormatter.format(value);
                this.tickLabels.add(tickLabel);
                double tickLabelPosition = margin + (value.doubleValue() - this.minValue) / (this.maxValue - this.minValue) * tickSpace;
                this.tickLocations.add(tickLabelPosition);
                value = value.add(cleanedGridStep);
            }
        } while (!this.willLabelsFitInTickSpaceHint(this.tickLabels, gridStepInChartSpace));
    }

    private static double pow(int exponent) {
        return exponent > 0 ? Math.pow(10.0, exponent) : 1.0 / Math.pow(10.0, -1 * exponent);
    }
}

