/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.axis;

import java.util.Map;
import org.xbib.graphics.chart.axis.AxisTickCalculator;
import org.xbib.graphics.chart.axis.DataType;
import org.xbib.graphics.chart.axis.Direction;
import org.xbib.graphics.chart.formatter.DateFormatter;
import org.xbib.graphics.chart.formatter.NumberFormatter;
import org.xbib.graphics.chart.formatter.StringFormatter;
import org.xbib.graphics.chart.style.AxesChartStyler;

class AxisTickCalculatorOverride
extends AxisTickCalculator {
    public AxisTickCalculatorOverride(Direction axisDirection, double workingSpace, double minValue, double maxValue, AxesChartStyler styler, Map<Double, Object> labelOverrideMap) {
        super(axisDirection, workingSpace, minValue, maxValue, styler);
        this.axisFormat = new NumberFormatter(styler, axisDirection, minValue, maxValue);
        this.calculate(labelOverrideMap);
    }

    public AxisTickCalculatorOverride(Direction axisDirection, double workingSpace, AxesChartStyler styler, Map<Double, Object> markMap, DataType axisType, int categoryCount) {
        super(axisDirection, workingSpace, Double.NaN, Double.NaN, styler);
        if (axisType == DataType.String) {
            this.axisFormat = new StringFormatter();
        } else if (axisType == DataType.Number) {
            this.axisFormat = new NumberFormatter(styler, axisDirection, this.minValue, this.maxValue);
        } else if (axisType == DataType.Instant) {
            this.axisFormat = new DateFormatter(styler.getDatePattern(), styler.getLocale());
        }
        this.calculateForCategory(markMap, categoryCount);
    }

    private void calculate(Map<Double, Object> labelOverrideMap) {
        if (this.minValue == this.maxValue) {
            String label = labelOverrideMap.isEmpty() ? " " : labelOverrideMap.values().iterator().next().toString();
            this.tickLabels.add(label);
            this.tickLocations.add(this.workingSpace / 2.0);
            return;
        }
        double tickSpace = this.styler.getPlotContentSize() * this.workingSpace;
        if (tickSpace < (double)this.styler.getXAxisTickMarkSpacingHint()) {
            return;
        }
        double margin = (this.workingSpace - tickSpace) / 2.0;
        for (Map.Entry<Double, Object> entry : labelOverrideMap.entrySet()) {
            Object value = entry.getValue();
            String tickLabel = value == null ? " " : value.toString();
            this.tickLabels.add(tickLabel);
            double tickLabelPosition = margin + (entry.getKey() - this.minValue) / (this.maxValue - this.minValue) * tickSpace;
            this.tickLocations.add(tickLabelPosition);
        }
    }

    private void calculateForCategory(Map<Double, Object> locationLabelMap, int categoryCount) {
        double tickSpace = this.styler.getPlotContentSize() * this.workingSpace;
        double margin = (this.workingSpace - tickSpace) / 2.0;
        double gridStep = tickSpace / (double)categoryCount;
        double firstPosition = gridStep / 2.0;
        for (Map.Entry<Double, Object> entry : locationLabelMap.entrySet()) {
            Object value = entry.getValue();
            String tickLabel = value == null ? " " : value.toString();
            this.tickLabels.add(tickLabel);
            double tickLabelPosition = margin + firstPosition + gridStep * entry.getKey();
            this.tickLocations.add(tickLabelPosition);
        }
    }
}

