/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.axis;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.HashMap;
import java.util.Map;
import org.xbib.graphics.chart.Chart;
import org.xbib.graphics.chart.ChartComponent;
import org.xbib.graphics.chart.axis.Axis;
import org.xbib.graphics.chart.axis.Direction;
import org.xbib.graphics.chart.axis.YAxisPosition;
import org.xbib.graphics.chart.series.AxesChartSeries;
import org.xbib.graphics.chart.style.AxesChartStyler;

public class AxisTickLabels<ST extends AxesChartStyler, S extends AxesChartSeries>
implements ChartComponent {
    private final Chart<ST, S> chart;
    private final Direction direction;
    private final Axis<ST, S> yAxis;
    private Rectangle2D bounds;

    protected AxisTickLabels(Chart<ST, S> chart, Direction direction, Axis<ST, S> yAxis) {
        this.chart = chart;
        this.direction = direction;
        this.yAxis = yAxis;
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }

    @Override
    public void paint(Graphics2D g) {
        AxesChartStyler styler = (AxesChartStyler)this.chart.getStyler();
        g.setFont(styler.getAxisTickLabelsFont());
        g.setColor(styler.getAxisTickLabelsColor());
        if (this.direction == Direction.Y && ((AxesChartStyler)this.chart.getStyler()).isYAxisTicksVisible()) {
            double xOffset;
            boolean onRight;
            boolean bl = onRight = styler.getYAxisGroupPosistion(this.yAxis.getYIndex()) == YAxisPosition.Right;
            if (onRight) {
                xOffset = this.yAxis.getBounds().getX() + (double)(styler.isYAxisTicksVisible() ? styler.getAxisTickMarkLength() + styler.getAxisTickPadding() : 0);
            } else {
                double xWidth = this.yAxis.getAxisTitle().getBounds().getWidth();
                xOffset = this.yAxis.getAxisTitle().getBounds().getX() + xWidth;
            }
            double yOffset = this.yAxis.getBounds().getY();
            double height = this.yAxis.getBounds().getHeight();
            double maxTickLabelWidth = 0.0;
            HashMap<Double, TextLayout> axisLabelTextLayouts = new HashMap<Double, TextLayout>();
            for (int i = 0; i < this.chart.getYAxis().getAxisTickCalculator().getTickLabels().size(); ++i) {
                String tickLabel = this.chart.getYAxis().getAxisTickCalculator().getTickLabels().get(i);
                double tickLocation = this.chart.getYAxis().getAxisTickCalculator().getTickLocations().get(i);
                double flippedTickLocation = yOffset + height - tickLocation;
                if (tickLabel == null || tickLabel.isEmpty() || !(flippedTickLocation > yOffset) || !(flippedTickLocation < yOffset + height)) continue;
                FontRenderContext frc = g.getFontRenderContext();
                TextLayout axisLabelTextLayout = new TextLayout(tickLabel, styler.getAxisTickLabelsFont(), frc);
                Rectangle2D tickLabelBounds = axisLabelTextLayout.getBounds();
                double boundWidth = tickLabelBounds.getWidth();
                if (boundWidth > maxTickLabelWidth) {
                    maxTickLabelWidth = boundWidth;
                }
                axisLabelTextLayouts.put(tickLocation, axisLabelTextLayout);
            }
            for (Map.Entry entry : axisLabelTextLayouts.entrySet()) {
                double xPos;
                Double tickLocation = (Double)entry.getKey();
                TextLayout axisLabelTextLayout = (TextLayout)axisLabelTextLayouts.get(tickLocation);
                Shape shape = axisLabelTextLayout.getOutline(null);
                Rectangle tickLabelBounds = shape.getBounds();
                double flippedTickLocation = yOffset + height - tickLocation;
                AffineTransform orig = g.getTransform();
                AffineTransform at = new AffineTransform();
                double boundWidth = ((RectangularShape)tickLabelBounds).getWidth();
                switch (((AxesChartStyler)this.chart.getStyler()).getYAxisLabelAlignment()) {
                    case Right: {
                        xPos = xOffset + maxTickLabelWidth - boundWidth;
                        break;
                    }
                    case Centre: {
                        xPos = xOffset + (maxTickLabelWidth - boundWidth) / 2.0;
                        break;
                    }
                    default: {
                        xPos = xOffset;
                    }
                }
                at.translate(xPos, flippedTickLocation + ((RectangularShape)tickLabelBounds).getHeight() / 2.0);
                g.transform(at);
                g.fill(shape);
                g.setTransform(orig);
            }
            this.bounds = new Rectangle2D.Double(xOffset, yOffset, maxTickLabelWidth, height);
        } else if (this.direction == Direction.X && ((AxesChartStyler)this.chart.getStyler()).isXAxisTicksVisible()) {
            Rectangle2D tickLabelBounds;
            Shape shape;
            AffineTransform rot;
            TextLayout textLayout;
            FontRenderContext frc;
            double shiftedTickLocation;
            double tickLocation;
            String tickLabel;
            int i;
            double xOffset = this.chart.getXAxis().getBounds().getX();
            double yOffset = this.chart.getXAxis().getAxisTitle().getBounds().getY();
            double width = this.chart.getXAxis().getBounds().getWidth();
            double maxTickLabelHeight = 0.0;
            int maxTickLabelY = 0;
            for (i = 0; i < this.chart.getXAxis().getAxisTickCalculator().getTickLabels().size(); ++i) {
                tickLabel = this.chart.getXAxis().getAxisTickCalculator().getTickLabels().get(i);
                tickLocation = this.chart.getXAxis().getAxisTickCalculator().getTickLocations().get(i);
                shiftedTickLocation = xOffset + tickLocation;
                if (tickLabel == null || tickLabel.isEmpty() || !(shiftedTickLocation > xOffset) || !(shiftedTickLocation < xOffset + width)) continue;
                frc = g.getFontRenderContext();
                textLayout = new TextLayout(tickLabel, ((AxesChartStyler)this.chart.getStyler()).getAxisTickLabelsFont(), frc);
                rot = AffineTransform.getRotateInstance(-1.0 * Math.toRadians(((AxesChartStyler)this.chart.getStyler()).getXAxisLabelRotation()), 0.0, 0.0);
                shape = textLayout.getOutline(rot);
                tickLabelBounds = shape.getBounds2D();
                if (tickLabelBounds.getBounds().height <= maxTickLabelY) continue;
                maxTickLabelY = tickLabelBounds.getBounds().height;
            }
            for (i = 0; i < this.chart.getXAxis().getAxisTickCalculator().getTickLabels().size(); ++i) {
                double xPos;
                tickLabel = this.chart.getXAxis().getAxisTickCalculator().getTickLabels().get(i);
                tickLocation = this.chart.getXAxis().getAxisTickCalculator().getTickLocations().get(i);
                shiftedTickLocation = xOffset + tickLocation;
                if (tickLabel == null || !(shiftedTickLocation > xOffset) || !(shiftedTickLocation < xOffset + width)) continue;
                frc = g.getFontRenderContext();
                textLayout = new TextLayout(tickLabel, styler.getAxisTickLabelsFont(), frc);
                rot = AffineTransform.getRotateInstance(-1.0 * Math.toRadians(styler.getXAxisLabelRotation()), 0.0, 0.0);
                shape = textLayout.getOutline(rot);
                tickLabelBounds = shape.getBounds2D();
                AffineTransform orig = g.getTransform();
                AffineTransform at = new AffineTransform();
                switch (styler.getXAxisLabelAlignment()) {
                    case Left: {
                        xPos = shiftedTickLocation;
                        break;
                    }
                    case Right: {
                        xPos = shiftedTickLocation - tickLabelBounds.getWidth();
                        break;
                    }
                    default: {
                        xPos = shiftedTickLocation - tickLabelBounds.getWidth() / 2.0;
                    }
                }
                double shiftX = -1.0 * tickLabelBounds.getX() * Math.sin(Math.toRadians(((AxesChartStyler)this.chart.getStyler()).getXAxisLabelRotation()));
                double shiftY = -1.0 * (tickLabelBounds.getY() + tickLabelBounds.getHeight());
                at.translate(xPos + shiftX, yOffset + shiftY);
                g.transform(at);
                g.fill(shape);
                g.setTransform(orig);
                if (!(tickLabelBounds.getHeight() > maxTickLabelHeight)) continue;
                maxTickLabelHeight = tickLabelBounds.getHeight();
            }
            this.bounds = new Rectangle2D.Double(xOffset, yOffset - maxTickLabelHeight, width, maxTickLabelHeight);
        } else {
            this.bounds = new Rectangle2D.Double();
        }
    }
}

