/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.axis;

import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.xbib.graphics.chart.Chart;
import org.xbib.graphics.chart.ChartComponent;
import org.xbib.graphics.chart.axis.Axis;
import org.xbib.graphics.chart.axis.Direction;
import org.xbib.graphics.chart.axis.YAxisPosition;
import org.xbib.graphics.chart.series.AxesChartSeries;
import org.xbib.graphics.chart.style.AxesChartStyler;

public class AxisTickMarks<ST extends AxesChartStyler, S extends AxesChartSeries>
implements ChartComponent {
    private final Chart<ST, S> chart;
    private final Direction direction;
    private final Axis<ST, S> yAxis;
    private Rectangle2D bounds;

    protected AxisTickMarks(Chart<ST, S> chart, Direction direction, Axis<ST, S> yAxis) {
        this.chart = chart;
        this.direction = direction;
        this.yAxis = yAxis;
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }

    @Override
    public void paint(Graphics2D g) {
        AxesChartStyler styler = (AxesChartStyler)this.chart.getStyler();
        g.setColor(styler.getAxisTickMarksColor());
        g.setStroke(styler.getAxisTickMarksStroke());
        if (this.direction == Direction.Y && ((AxesChartStyler)this.chart.getStyler()).isYAxisTicksVisible()) {
            double lineXOffset;
            double xOffset;
            int axisTickMarkLength = styler.getAxisTickMarkLength();
            boolean onRight = styler.getYAxisGroupPosistion(this.yAxis.getYIndex()) == YAxisPosition.Right;
            Rectangle2D yAxisBounds = this.yAxis.getBounds();
            Rectangle2D axisTickLabelBounds = this.yAxis.getAxisTick().getAxisTickLabels().getBounds();
            if (onRight) {
                lineXOffset = xOffset = axisTickLabelBounds.getX() - (double)styler.getAxisTickPadding() - (double)axisTickMarkLength;
            } else {
                xOffset = axisTickLabelBounds.getX() + axisTickLabelBounds.getWidth() + (double)styler.getAxisTickPadding();
                lineXOffset = xOffset + (double)axisTickMarkLength;
            }
            double yOffset = yAxisBounds.getY();
            this.bounds = new Rectangle2D.Double(xOffset, yOffset, styler.getAxisTickMarkLength(), this.yAxis.getBounds().getHeight());
            if (styler.isAxisTicksMarksVisible()) {
                for (int i = 0; i < this.chart.getYAxis().getAxisTickCalculator().getTickLabels().size(); ++i) {
                    double tickLocation = this.yAxis.getAxisTickCalculator().getTickLocations().get(i);
                    double flippedTickLocation = yOffset + yAxisBounds.getHeight() - tickLocation;
                    if (!(flippedTickLocation > this.bounds.getY()) || !(flippedTickLocation < this.bounds.getY() + this.bounds.getHeight())) continue;
                    Line2D.Double line = new Line2D.Double(xOffset, flippedTickLocation, xOffset + (double)axisTickMarkLength, flippedTickLocation);
                    g.draw(line);
                }
            }
            if (styler.isAxisTicksLineVisible()) {
                Line2D.Double line = new Line2D.Double(lineXOffset, yOffset, lineXOffset, yOffset + yAxisBounds.getHeight());
                g.draw(line);
            }
        } else if (this.direction == Direction.X && styler.isXAxisTicksVisible()) {
            int axisTickMarkLength = styler.getAxisTickMarkLength();
            double xOffset = this.chart.getXAxis().getBounds().getX();
            double yOffset = this.chart.getXAxis().getAxisTick().getAxisTickLabels().getBounds().getY() - (double)styler.getAxisTickPadding();
            this.bounds = new Rectangle2D.Double(xOffset, yOffset - (double)axisTickMarkLength, this.chart.getXAxis().getBounds().getWidth(), axisTickMarkLength);
            if (styler.isAxisTicksMarksVisible()) {
                for (int i = 0; i < this.chart.getXAxis().getAxisTickCalculator().getTickLabels().size(); ++i) {
                    double tickLocation = this.chart.getXAxis().getAxisTickCalculator().getTickLocations().get(i);
                    double shiftedTickLocation = xOffset + tickLocation;
                    if (!(shiftedTickLocation > this.bounds.getX()) || !(shiftedTickLocation < this.bounds.getX() + this.bounds.getWidth())) continue;
                    Line2D.Double line = new Line2D.Double(shiftedTickLocation, yOffset, xOffset + tickLocation, yOffset - (double)((AxesChartStyler)this.chart.getStyler()).getAxisTickMarkLength());
                    g.draw(line);
                }
            }
            if (styler.isAxisTicksLineVisible()) {
                g.setStroke(styler.getAxisTickMarksStroke());
                g.drawLine((int)xOffset, (int)(yOffset - (double)axisTickMarkLength), (int)(xOffset + this.chart.getXAxis().getBounds().getWidth()), (int)(yOffset - (double)axisTickMarkLength));
            } else {
                this.bounds = new Rectangle2D.Double();
            }
        }
    }
}

