/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.axis;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.xbib.graphics.chart.Chart;
import org.xbib.graphics.chart.ChartComponent;
import org.xbib.graphics.chart.axis.Axis;
import org.xbib.graphics.chart.axis.Direction;
import org.xbib.graphics.chart.axis.YAxisPosition;
import org.xbib.graphics.chart.series.Series;
import org.xbib.graphics.chart.style.AxesChartStyler;

public class AxisTitle<ST extends AxesChartStyler, S extends Series>
implements ChartComponent {
    private final Chart<ST, S> chart;
    private final Direction direction;
    private final Axis<ST, ?> yAxis;
    private final int yIndex;
    private Rectangle2D bounds;

    public AxisTitle(Chart<ST, S> chart, Direction direction, Axis<ST, ?> yAxis, int yIndex) {
        this.chart = chart;
        this.direction = direction;
        this.yAxis = yAxis;
        this.yIndex = yIndex;
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }

    @Override
    public void paint(Graphics2D g) {
        this.bounds = new Rectangle2D.Double();
        g.setColor(((AxesChartStyler)this.chart.getStyler()).getChartFontColor());
        g.setFont(((AxesChartStyler)this.chart.getStyler()).getAxisTitleFont());
        if (this.direction == Direction.Y) {
            String yAxisTitle = this.chart.getYAxisGroupTitle(this.yIndex);
            if (yAxisTitle != null && !yAxisTitle.trim().equalsIgnoreCase("") && ((AxesChartStyler)this.chart.getStyler()).isYAxisTitleVisible()) {
                FontRenderContext frc = g.getFontRenderContext();
                TextLayout nonRotatedTextLayout = new TextLayout(this.chart.getyYAxisTitle(), ((AxesChartStyler)this.chart.getStyler()).getAxisTitleFont(), frc);
                Rectangle2D nonRotatedRectangle = nonRotatedTextLayout.getBounds();
                boolean onRight = ((AxesChartStyler)this.chart.getStyler()).getYAxisGroupPosistion(this.yAxis.getYIndex()) == YAxisPosition.Right;
                int xOffset = onRight ? (int)(this.yAxis.getAxisTick().getBounds().getX() + this.yAxis.getAxisTick().getBounds().getWidth() + nonRotatedRectangle.getHeight()) : (int)(this.yAxis.getBounds().getX() + nonRotatedRectangle.getHeight());
                int yOffset = (int)((this.yAxis.getBounds().getHeight() + nonRotatedRectangle.getWidth()) / 2.0 + this.yAxis.getBounds().getY());
                AffineTransform rot = AffineTransform.getRotateInstance(-1.5707963267948966, 0.0, 0.0);
                Shape shape = nonRotatedTextLayout.getOutline(rot);
                AffineTransform orig = g.getTransform();
                AffineTransform at = new AffineTransform();
                at.translate(xOffset, yOffset);
                g.transform(at);
                g.fill(shape);
                g.setTransform(orig);
                this.bounds = new Rectangle2D.Double((double)xOffset - nonRotatedRectangle.getHeight(), (double)yOffset - nonRotatedRectangle.getWidth(), nonRotatedRectangle.getHeight() + (double)((AxesChartStyler)this.chart.getStyler()).getAxisTitlePadding(), nonRotatedRectangle.getWidth());
            } else {
                this.bounds = new Rectangle2D.Double(this.yAxis.getBounds().getX(), this.yAxis.getBounds().getY(), 0.0, this.yAxis.getBounds().getHeight());
            }
        } else if (this.chart.getXAxisTitle() != null && !this.chart.getXAxisTitle().trim().equalsIgnoreCase("") && ((AxesChartStyler)this.chart.getStyler()).isXAxisTitleVisible()) {
            FontRenderContext frc = g.getFontRenderContext();
            TextLayout textLayout = new TextLayout(this.chart.getXAxisTitle(), ((AxesChartStyler)this.chart.getStyler()).getAxisTitleFont(), frc);
            Rectangle2D rectangle = textLayout.getBounds();
            double xOffset = this.chart.getXAxis().getBounds().getX() + (this.chart.getXAxis().getBounds().getWidth() - rectangle.getWidth()) / 2.0;
            double yOffset = this.chart.getXAxis().getBounds().getY() + this.chart.getXAxis().getBounds().getHeight() - rectangle.getHeight();
            Shape shape = textLayout.getOutline(null);
            AffineTransform orig = g.getTransform();
            AffineTransform at = new AffineTransform();
            at.translate((float)xOffset, (float)(yOffset - rectangle.getY()));
            g.transform(at);
            g.fill(shape);
            g.setTransform(orig);
            this.bounds = new Rectangle2D.Double(xOffset, yOffset - (double)((AxesChartStyler)this.chart.getStyler()).getAxisTitlePadding(), rectangle.getWidth(), rectangle.getHeight() + (double)((AxesChartStyler)this.chart.getStyler()).getAxisTitlePadding());
        } else {
            this.bounds = new Rectangle2D.Double(this.chart.getXAxis().getBounds().getX(), this.chart.getXAxis().getBounds().getY() + this.chart.getXAxis().getBounds().getHeight(), this.chart.getXAxis().getBounds().getWidth(), 0.0);
        }
    }
}

