/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.bubble;

import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.util.List;
import java.util.Map;
import org.xbib.graphics.chart.Chart;
import org.xbib.graphics.chart.axis.AxisPair;
import org.xbib.graphics.chart.bubble.BubbleChartBuilder;
import org.xbib.graphics.chart.bubble.BubbleLegend;
import org.xbib.graphics.chart.bubble.BubbleSeries;
import org.xbib.graphics.chart.bubble.BubbleSeriesRenderStyle;
import org.xbib.graphics.chart.bubble.BubbleStyler;
import org.xbib.graphics.chart.plot.AxesChartPlot;
import org.xbib.graphics.chart.plot.ContentPlot;
import org.xbib.graphics.chart.style.AxesChartStyler;
import org.xbib.graphics.chart.style.SeriesColorMarkerLineStyle;
import org.xbib.graphics.chart.style.SeriesColorMarkerLineStyleCycler;
import org.xbib.graphics.chart.style.Styler;
import org.xbib.graphics.chart.theme.Theme;

public class BubbleChart
extends Chart<BubbleStyler, BubbleSeries> {
    public BubbleChart(int width, int height) {
        super(width, height, new BubbleStyler());
        this.axisPair = new AxisPair<BubbleStyler, BubbleSeries>(this);
        this.plot = new BubblePlot<BubbleStyler, BubbleSeries>(this);
        this.legend = new BubbleLegend<BubbleStyler, BubbleSeries>(this);
    }

    public BubbleChart(int width, int height, Theme theme) {
        this(width, height);
        ((BubbleStyler)this.styler).setTheme(theme);
    }

    public BubbleChart(BubbleChartBuilder chartBuilder) {
        this(chartBuilder.getWidth(), chartBuilder.getHeight(), chartBuilder.getTheme());
        this.setTitle(chartBuilder.getTitle());
        this.setXAxisTitle(chartBuilder.xAxisTitle);
        this.setYAxisTitle(chartBuilder.yAxisTitle);
    }

    public BubbleSeries addSeries(String seriesName, List<?> xData, List<? extends Number> yData, List<? extends Number> bubbleData) {
        BubbleSeries series;
        this.sanityCheck(seriesName, xData, yData, bubbleData);
        if (xData != null) {
            if (xData.size() != yData.size()) {
                throw new IllegalArgumentException("X and Y-Axis sizes are not the same");
            }
            series = new BubbleSeries(seriesName, xData, yData, bubbleData);
        } else {
            series = new BubbleSeries(seriesName, this.getGeneratedData(yData.size()), yData, bubbleData);
        }
        this.seriesMap.put(seriesName, series);
        return series;
    }

    private void sanityCheck(String seriesName, List<?> xData, List<? extends Number> yData, List<? extends Number> bubbleData) {
        if (this.seriesMap.containsKey(seriesName)) {
            throw new IllegalArgumentException("Series name >" + seriesName + "< has already been used. Use unique names for each series");
        }
        if (yData == null) {
            throw new IllegalArgumentException("Y-Axis data cannot be null >" + seriesName);
        }
        if (yData.size() == 0) {
            throw new IllegalArgumentException("Y-Axis data cannot be empty >" + seriesName);
        }
        if (bubbleData == null) {
            throw new IllegalArgumentException("Bubble data cannot be null >" + seriesName);
        }
        if (bubbleData.size() == 0) {
            throw new IllegalArgumentException("Bubble data cannot be empty >" + seriesName);
        }
        if (xData != null && xData.size() == 0) {
            throw new IllegalArgumentException("X-Axis data cannot be empty >" + seriesName);
        }
        if (bubbleData.size() != yData.size()) {
            throw new IllegalArgumentException("Bubble Data and Y-Axis sizes are not the same >" + seriesName);
        }
    }

    @Override
    public void paint(Graphics2D g, int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
        for (BubbleSeries bubbleSeries : this.getSeriesMap().values()) {
            BubbleSeriesRenderStyle seriesType = bubbleSeries.getBubbleSeriesRenderStyle();
            if (seriesType != null) continue;
            bubbleSeries.setBubbleSeriesRenderStyle(((BubbleStyler)this.getStyler()).getDefaultSeriesRenderStyle());
        }
        this.setSeriesStyles();
        this.paintBackground(g);
        this.axisPair.paint(g);
        this.plot.paint(g);
        this.chartTitle.paint(g);
        this.legend.paint(g);
    }

    private void setSeriesStyles() {
        SeriesColorMarkerLineStyleCycler seriesColorMarkerLineStyleCycler = new SeriesColorMarkerLineStyleCycler(((BubbleStyler)this.getStyler()).getSeriesColors(), ((BubbleStyler)this.getStyler()).getSeriesMarkers(), ((BubbleStyler)this.getStyler()).getSeriesLines());
        for (BubbleSeries series : this.getSeriesMap().values()) {
            SeriesColorMarkerLineStyle seriesColorMarkerLineStyle = seriesColorMarkerLineStyleCycler.getNextSeriesColorMarkerLineStyle();
            if (series.getLineStyle() == null) {
                series.setLineStyle(seriesColorMarkerLineStyle.getStroke());
            }
            if (series.getLineColor() == null) {
                series.setLineColor(seriesColorMarkerLineStyle.getColor());
            }
            if (series.getFillColor() != null) continue;
            series.setFillColor(seriesColorMarkerLineStyle.getColor());
        }
    }

    private static class BubbleContentPlot<ST extends BubbleStyler, S extends BubbleSeries>
    extends ContentPlot<ST, S> {
        private final ST stylerBubble;

        private BubbleContentPlot(Chart<ST, S> chart) {
            super(chart);
            this.stylerBubble = (BubbleStyler)chart.getStyler();
        }

        @Override
        public void doPaint(Graphics2D g) {
            double xTickSpace = ((Styler)this.stylerBubble).getPlotContentSize() * this.getBounds().getWidth();
            double xLeftMargin = ((double)((int)this.getBounds().getWidth()) - xTickSpace) / 2.0;
            double yTickSpace = ((Styler)this.stylerBubble).getPlotContentSize() * this.getBounds().getHeight();
            double yTopMargin = ((double)((int)this.getBounds().getHeight()) - yTickSpace) / 2.0;
            double xMin = this.chart.getXAxis().getMin();
            double xMax = this.chart.getXAxis().getMax();
            if (((AxesChartStyler)this.stylerBubble).isXAxisLogarithmic()) {
                xMin = Math.log10(xMin);
                xMax = Math.log10(xMax);
            }
            Map map = this.chart.getSeriesMap();
            for (BubbleSeries series : map.values()) {
                if (!series.isEnabled()) continue;
                double yMin = this.chart.getYAxis(series.getYAxisGroup()).getMin();
                double yMax = this.chart.getYAxis(series.getYAxisGroup()).getMax();
                if (((AxesChartStyler)this.stylerBubble).isYAxisLogarithmic()) {
                    yMin = Math.log10(yMin);
                    yMax = Math.log10(yMax);
                }
                for (int i = 0; i < series.getXData().size(); ++i) {
                    Double x = (Double)series.getXData().get(i);
                    if (((AxesChartStyler)this.stylerBubble).isXAxisLogarithmic()) {
                        x = Math.log10(x);
                    }
                    if (Double.isNaN((Double)series.getYData().get(i))) continue;
                    Double yOrig = (Double)series.getYData().get(i);
                    double y = ((AxesChartStyler)this.stylerBubble).isYAxisLogarithmic() ? Math.log10(yOrig) : yOrig;
                    double xTransform = xLeftMargin + (x - xMin) / (xMax - xMin) * xTickSpace;
                    double yTransform = this.getBounds().getHeight() - (yTopMargin + (y - yMin) / (yMax - yMin) * yTickSpace);
                    if (Math.abs(xMax - xMin) / 5.0 == 0.0) {
                        xTransform = this.getBounds().getWidth() / 2.0;
                    }
                    if (Math.abs(yMax - yMin) / 5.0 == 0.0) {
                        yTransform = this.getBounds().getHeight() / 2.0;
                    }
                    double xOffset = this.getBounds().getX() + xTransform;
                    double yOffset = this.getBounds().getY() + yTransform;
                    if (series.getExtraValues() == null) continue;
                    Double bubbleSize = (Double)series.getExtraValues().get(i);
                    Ellipse2D.Double bubble = new Ellipse2D.Double(xOffset - bubbleSize / 2.0, yOffset - bubbleSize / 2.0, bubbleSize, bubbleSize);
                    g.setColor(series.getFillColor());
                    g.fill(bubble);
                    g.setColor(series.getLineColor());
                    g.setStroke(series.getLineStyle());
                    g.draw(bubble);
                }
            }
        }
    }

    private static class BubblePlot<ST extends BubbleStyler, S extends BubbleSeries>
    extends AxesChartPlot<ST, S> {
        private BubblePlot(Chart<ST, S> chart) {
            super(chart);
            this.contentPlot = new BubbleContentPlot<ST, S>(chart);
        }
    }
}

