/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.category;

import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xbib.graphics.chart.Chart;
import org.xbib.graphics.chart.axis.Axis;
import org.xbib.graphics.chart.axis.AxisPair;
import org.xbib.graphics.chart.axis.DataType;
import org.xbib.graphics.chart.category.CategoryChartBuilder;
import org.xbib.graphics.chart.category.CategorySeries;
import org.xbib.graphics.chart.category.CategorySeriesRenderStyle;
import org.xbib.graphics.chart.category.CategoryStyler;
import org.xbib.graphics.chart.legend.MarkerLegend;
import org.xbib.graphics.chart.plot.AxesChartPlot;
import org.xbib.graphics.chart.plot.ContentPlot;
import org.xbib.graphics.chart.series.AxesChartSeries;
import org.xbib.graphics.chart.series.Series;
import org.xbib.graphics.chart.style.AxesChartStyler;
import org.xbib.graphics.chart.style.SeriesColorMarkerLineStyle;
import org.xbib.graphics.chart.style.SeriesColorMarkerLineStyleCycler;
import org.xbib.graphics.chart.style.Styler;
import org.xbib.graphics.chart.theme.Theme;

public class CategoryChart
extends Chart<CategoryStyler, CategorySeries> {
    public CategoryChart(int width, int height) {
        super(width, height, new CategoryStyler());
        this.axisPair = new AxisPair<CategoryStyler, CategorySeries>(this);
        this.plot = new CategoryPlot<CategoryStyler, CategorySeries>(this);
        this.legend = new MarkerLegend<CategoryStyler, CategorySeries>(this);
    }

    public CategoryChart(int width, int height, Theme theme) {
        this(width, height);
        ((CategoryStyler)this.styler).setTheme(theme);
    }

    public CategoryChart(CategoryChartBuilder chartBuilder) {
        this(chartBuilder.getWidth(), chartBuilder.getHeight(), chartBuilder.getTheme());
        this.setTitle(chartBuilder.getTitle());
        this.setXAxisTitle(chartBuilder.getxAxisTitle());
        this.setYAxisTitle(chartBuilder.getyAxisTitle());
    }

    public CategorySeries addSeries(String seriesName, double[] xData, double[] yData) {
        return this.addSeries(seriesName, xData, yData, null);
    }

    public CategorySeries addSeries(String seriesName, double[] xData, double[] yData, double[] errorBars) {
        return this.addSeries(seriesName, this.listFromDoubleArray(xData), this.listFromDoubleArray(yData), this.listFromDoubleArray(errorBars));
    }

    public CategorySeries addSeries(String seriesName, int[] xData, int[] yData) {
        return this.addSeries(seriesName, xData, yData, (int[])null);
    }

    public CategorySeries addSeries(String seriesName, int[] xData, int[] yData, int[] errorBars) {
        return this.addSeries(seriesName, this.listFromIntArray(xData), this.listFromIntArray(yData), this.listFromIntArray(errorBars));
    }

    public CategorySeries addSeries(String seriesName, List<?> xData, List<? extends Number> yData) {
        return this.addSeries(seriesName, xData, yData, null);
    }

    public CategorySeries addSeries(String seriesName, List<?> xData, List<? extends Number> yData, List<? extends Number> errorBars) {
        CategorySeries series;
        this.sanityCheck(seriesName, xData, yData, errorBars);
        if (xData != null) {
            if (xData.size() != yData.size()) {
                throw new IllegalArgumentException("X and Y-Axis sizes are not the same");
            }
            series = new CategorySeries(seriesName, xData, yData, errorBars, this.getDataType(xData));
        } else {
            series = new CategorySeries(seriesName, this.getGeneratedData(yData.size()), yData, errorBars, DataType.String);
        }
        this.seriesMap.put(seriesName, series);
        return series;
    }

    private void sanityCheck(String seriesName, List<?> xData, List<? extends Number> yData, List<? extends Number> errorBars) {
        if (this.seriesMap.containsKey(seriesName)) {
            throw new IllegalArgumentException("Series name >" + seriesName + "< has already been used");
        }
        if (yData == null) {
            throw new IllegalArgumentException("Y-Axis data cannot be null");
        }
        if (yData.size() == 0) {
            throw new IllegalArgumentException("Y-Axis data cannot be empty");
        }
        if (xData != null && xData.size() == 0) {
            throw new IllegalArgumentException("X-Axis data cannot be empty");
        }
        if (errorBars != null && errorBars.size() != yData.size()) {
            throw new IllegalArgumentException("Error bars and Y-Axis sizes are not the same");
        }
    }

    @Override
    public void paint(Graphics2D g, int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
        for (CategorySeries categorySeries : this.getSeriesMap().values()) {
            CategorySeriesRenderStyle seriesType = categorySeries.getCategorySeriesRenderStyle();
            if (seriesType != null) continue;
            categorySeries.setCategorySeriesRenderStyle(((CategoryStyler)this.getStyler()).getDefaultSeriesRenderStyle());
        }
        this.setSeriesStyles();
        this.paintBackground(g);
        this.axisPair.paint(g);
        this.plot.paint(g);
        this.chartTitle.paint(g);
        this.legend.paint(g);
    }

    public void setSeriesStyles() {
        SeriesColorMarkerLineStyleCycler seriesColorMarkerLineStyleCycler = new SeriesColorMarkerLineStyleCycler(((CategoryStyler)this.getStyler()).getSeriesColors(), ((CategoryStyler)this.getStyler()).getSeriesMarkers(), ((CategoryStyler)this.getStyler()).getSeriesLines());
        for (CategorySeries series : this.getSeriesMap().values()) {
            SeriesColorMarkerLineStyle seriesColorMarkerLineStyle = seriesColorMarkerLineStyleCycler.getNextSeriesColorMarkerLineStyle();
            if (series.getLineStyle() == null) {
                series.setLineStyle(seriesColorMarkerLineStyle.getStroke());
            }
            if (series.getLineColor() == null) {
                series.setLineColor(seriesColorMarkerLineStyle.getColor());
            }
            if (series.getFillColor() == null) {
                series.setFillColor(seriesColorMarkerLineStyle.getColor());
            }
            if (series.getMarker() == null) {
                series.setMarker(seriesColorMarkerLineStyle.getMarker());
            }
            if (series.getMarkerColor() != null) continue;
            series.setMarkerColor(seriesColorMarkerLineStyle.getColor());
        }
    }

    private DataType getDataType(List<?> data) {
        DataType axisType;
        Iterator<?> itr = data.iterator();
        Object dataPoint = itr.next();
        if (dataPoint instanceof Number) {
            axisType = DataType.Number;
        } else if (dataPoint instanceof Instant) {
            axisType = DataType.Instant;
        } else if (dataPoint instanceof String) {
            axisType = DataType.String;
        } else {
            throw new IllegalArgumentException("Series data must be either Number, Instant or String type");
        }
        return axisType;
    }

    private static class ContentPlotCategoryLineAreaScatter<ST extends CategoryStyler, S extends CategorySeries>
    extends ContentPlot<ST, S> {
        private final ST categoryStyler;

        protected ContentPlotCategoryLineAreaScatter(Chart<ST, S> chart) {
            super(chart);
            this.categoryStyler = (CategoryStyler)chart.getStyler();
        }

        @Override
        public void doPaint(Graphics2D g) {
            double xTickSpace = ((Styler)this.categoryStyler).getPlotContentSize() * this.getBounds().getWidth();
            double xLeftMargin = ((double)((int)this.getBounds().getWidth()) - xTickSpace) / 2.0;
            double yTickSpace = ((Styler)this.categoryStyler).getPlotContentSize() * this.getBounds().getHeight();
            double yTopMargin = ((double)((int)this.getBounds().getHeight()) - yTickSpace) / 2.0;
            Map seriesMap = this.chart.getSeriesMap();
            int numCategories = ((CategorySeries)seriesMap.values().iterator().next()).getXData().size();
            double gridStep = xTickSpace / (double)numCategories;
            for (CategorySeries series : seriesMap.values()) {
                if (!series.isEnabled()) continue;
                Axis<?, ?> yAxis = this.chart.getYAxis(series.getYAxisGroup());
                double yMin = yAxis.getMin();
                double yMax = yAxis.getMax();
                if (((AxesChartStyler)this.categoryStyler).isYAxisLogarithmic()) {
                    yMin = Math.log10(yMin);
                    yMax = Math.log10(yMax);
                }
                Collection<? extends Number> yData = series.getYData();
                double previousX = -1.7976931348623157E308;
                double previousY = -1.7976931348623157E308;
                Iterator<? extends Number> yItr = yData.iterator();
                Iterator<? extends Number> ebItr = null;
                Collection<? extends Number> errorBars = series.getExtraValues();
                if (errorBars != null) {
                    ebItr = errorBars.iterator();
                }
                Path2D.Double path = null;
                int categoryCounter = 0;
                while (yItr.hasNext()) {
                    double bottomValue;
                    double topValue;
                    Number next = yItr.next();
                    if (next == null) {
                        this.closePath(g, path, previousX, yTopMargin);
                        path = null;
                        previousX = -1.7976931348623157E308;
                        previousY = -1.7976931348623157E308;
                        continue;
                    }
                    double yOrig = next.doubleValue();
                    double y = ((AxesChartStyler)this.categoryStyler).isYAxisLogarithmic() ? Math.log10(yOrig) : yOrig;
                    double yTransform = this.getBounds().getHeight() - (yTopMargin + (y - yMin) / (yMax - yMin) * yTickSpace);
                    if (Math.abs(yMax - yMin) / 5.0 == 0.0) {
                        yTransform = this.getBounds().getHeight() / 2.0;
                    }
                    double xOffset = this.getBounds().getX() + xLeftMargin + (double)categoryCounter++ * gridStep + gridStep / 2.0;
                    double yOffset = this.getBounds().getY() + yTransform;
                    if ((CategorySeriesRenderStyle.Line.equals(series.getCategorySeriesRenderStyle()) || CategorySeriesRenderStyle.Area.equals(series.getCategorySeriesRenderStyle())) && series.getLineStyle() != Theme.Series.NONE_STROKE && previousX != -1.7976931348623157E308 && previousY != -1.7976931348623157E308) {
                        g.setColor(series.getLineColor());
                        g.setStroke(series.getLineStyle());
                        Line2D.Double line = new Line2D.Double(previousX, previousY, xOffset, yOffset);
                        g.draw(line);
                    }
                    if (CategorySeriesRenderStyle.Area.equals(series.getCategorySeriesRenderStyle())) {
                        if (previousX != -1.7976931348623157E308 && previousY != -1.7976931348623157E308) {
                            g.setColor(series.getFillColor());
                            double yBottomOfArea = this.getBounds().getY() + this.getBounds().getHeight() - yTopMargin;
                            if (path == null) {
                                path = new Path2D.Double();
                                path.moveTo(previousX, yBottomOfArea);
                                path.lineTo(previousX, previousY);
                            }
                            path.lineTo(xOffset, yOffset);
                        }
                        if (xOffset < previousX) {
                            throw new RuntimeException("X-Data must be in ascending order for Area Charts");
                        }
                    }
                    if (CategorySeriesRenderStyle.Stick.equals(series.getCategorySeriesRenderStyle()) && series.getLineStyle() != Theme.Series.NONE_STROKE) {
                        double yBottomOfArea = this.getBounds().getY() + this.getBounds().getHeight() - yTopMargin;
                        g.setColor(series.getLineColor());
                        g.setStroke(series.getLineStyle());
                        Line2D.Double line = new Line2D.Double(xOffset, yBottomOfArea, xOffset, yOffset);
                        g.draw(line);
                    }
                    previousX = xOffset;
                    previousY = yOffset;
                    if (series.getMarker() != null) {
                        g.setColor(series.getMarkerColor());
                        series.getMarker().paint(g, xOffset, yOffset, ((AxesChartStyler)this.categoryStyler).getMarkerSize());
                    }
                    if (errorBars == null) continue;
                    double eb = ebItr.next().doubleValue();
                    if (((AxesChartStyler)this.categoryStyler).isErrorBarsColorSeriesColor()) {
                        g.setColor(series.getLineColor());
                    } else {
                        g.setColor(((AxesChartStyler)this.categoryStyler).getErrorBarsColor());
                    }
                    g.setStroke(Theme.Strokes.ERROR_BARS);
                    if (((AxesChartStyler)this.categoryStyler).isYAxisLogarithmic()) {
                        topValue = yOrig + eb;
                        topValue = Math.log10(topValue);
                    } else {
                        topValue = y + eb;
                    }
                    double topEBTransform = this.getBounds().getHeight() - (yTopMargin + (topValue - yMin) / (yMax - yMin) * yTickSpace);
                    double topEBOffset = this.getBounds().getY() + topEBTransform;
                    if (((AxesChartStyler)this.categoryStyler).isYAxisLogarithmic()) {
                        bottomValue = yOrig - eb;
                        bottomValue = Math.log10(bottomValue);
                    } else {
                        bottomValue = y - eb;
                    }
                    double bottomEBTransform = this.getBounds().getHeight() - (yTopMargin + (bottomValue - yMin) / (yMax - yMin) * yTickSpace);
                    double bottomEBOffset = this.getBounds().getY() + bottomEBTransform;
                    Line2D.Double line = new Line2D.Double(xOffset, topEBOffset, xOffset, bottomEBOffset);
                    g.draw(line);
                    line = new Line2D.Double(xOffset - 3.0, bottomEBOffset, xOffset + 3.0, bottomEBOffset);
                    g.draw(line);
                    line = new Line2D.Double(xOffset - 3.0, topEBOffset, xOffset + 3.0, topEBOffset);
                    g.draw(line);
                }
                g.setColor(series.getFillColor());
                this.closePath(g, path, previousX, yTopMargin);
            }
        }
    }

    private static class ContentPlotCategoryBar<ST extends CategoryStyler, S extends CategorySeries>
    extends ContentPlot<ST, S> {
        private final ST stylerCategory;

        ContentPlotCategoryBar(Chart<ST, S> chart) {
            super(chart);
            this.stylerCategory = (CategoryStyler)chart.getStyler();
        }

        @Override
        public void doPaint(Graphics2D g) {
            double xTickSpace = ((Styler)this.stylerCategory).getPlotContentSize() * this.getBounds().getWidth();
            double xLeftMargin = (this.getBounds().getWidth() - xTickSpace) / 2.0;
            Map seriesMap = this.chart.getSeriesMap();
            int numCategories = ((CategorySeries)seriesMap.values().iterator().next()).getXData().size();
            double gridStep = xTickSpace / (double)numCategories;
            double yMin = this.chart.getYAxis().getMin();
            double yMax = this.chart.getYAxis().getMax();
            int chartForm = yMin > 0.0 && yMax > 0.0 ? 1 : (yMin < 0.0 && yMax < 0.0 ? -1 : 0);
            double yTickSpace = ((Styler)this.stylerCategory).getPlotContentSize() * this.getBounds().getHeight();
            double yTopMargin = (this.getBounds().getHeight() - yTickSpace) / 2.0;
            int seriesCounter = 0;
            double[] accumulatedStackOffsetPos = new double[numCategories];
            double[] accumulatedStackOffsetNeg = new double[numCategories];
            for (CategorySeries series : seriesMap.values()) {
                double previousX = -1.7976931348623157E308;
                double previousY = -1.7976931348623157E308;
                Iterator<? extends Number> yItr = series.getYData().iterator();
                Iterator<? extends Number> ebItr = null;
                Collection<? extends Number> errorBars = series.getExtraValues();
                if (errorBars != null) {
                    ebItr = errorBars.iterator();
                }
                ArrayList<Point2D.Double> steppedPath = null;
                ArrayList<Point2D.Double> steppedReturnPath = null;
                int categoryCounter = 0;
                block6: while (yItr.hasNext()) {
                    double xOffset;
                    double barMargin;
                    double barWidth;
                    Number next = yItr.next();
                    if (next == null) {
                        previousX = -1.7976931348623157E308;
                        previousY = -1.7976931348623157E308;
                        ++categoryCounter;
                        continue;
                    }
                    double y = next.doubleValue();
                    double yTop = 0.0;
                    double yBottom = 0.0;
                    switch (chartForm) {
                        case 1: {
                            if (y < yMin) {
                                ++categoryCounter;
                                continue block6;
                            }
                            yTop = y;
                            yBottom = yMin;
                            break;
                        }
                        case -1: {
                            if (y > yMax) {
                                ++categoryCounter;
                                continue block6;
                            }
                            yTop = yMax;
                            yBottom = y;
                            break;
                        }
                        case 0: {
                            if (y >= 0.0) {
                                yTop = y;
                                yBottom = series.getCategorySeriesRenderStyle() == CategorySeriesRenderStyle.Bar || series.getCategorySeriesRenderStyle() == CategorySeriesRenderStyle.Stick || series.getCategorySeriesRenderStyle() == CategorySeriesRenderStyle.SteppedBar ? 0.0 : y;
                                if (!((CategoryStyler)this.stylerCategory).isStacked()) break;
                                int n = categoryCounter;
                                accumulatedStackOffsetPos[n] = accumulatedStackOffsetPos[n] + ((yTop += accumulatedStackOffsetPos[categoryCounter]) - (yBottom += accumulatedStackOffsetPos[categoryCounter]));
                                break;
                            }
                            yTop = series.getCategorySeriesRenderStyle() == CategorySeriesRenderStyle.Bar || series.getCategorySeriesRenderStyle() == CategorySeriesRenderStyle.Stick || series.getCategorySeriesRenderStyle() == CategorySeriesRenderStyle.SteppedBar ? 0.0 : y;
                            yBottom = y;
                            if (!((CategoryStyler)this.stylerCategory).isStacked()) break;
                            int n = categoryCounter;
                            accumulatedStackOffsetNeg[n] = accumulatedStackOffsetNeg[n] + ((yTop -= accumulatedStackOffsetNeg[categoryCounter]) - (yBottom -= accumulatedStackOffsetNeg[categoryCounter]));
                            break;
                        }
                    }
                    double yTransform = this.getBounds().getHeight() - (yTopMargin + (yTop - yMin) / (yMax - yMin) * yTickSpace);
                    double yOffset = this.getBounds().getY() + yTransform;
                    double zeroTransform = this.getBounds().getHeight() - (yTopMargin + (yBottom - yMin) / (yMax - yMin) * yTickSpace);
                    double zeroOffset = this.getBounds().getY() + zeroTransform;
                    double barWidthPercentage = ((CategoryStyler)this.stylerCategory).getAvailableSpaceFill();
                    if (series.getCategorySeriesRenderStyle() == CategorySeriesRenderStyle.SteppedBar) {
                        barWidthPercentage = 1.0;
                    }
                    if (((CategoryStyler)this.stylerCategory).isOverlapped() || ((CategoryStyler)this.stylerCategory).isStacked()) {
                        barWidth = gridStep * barWidthPercentage;
                        barMargin = gridStep * (1.0 - barWidthPercentage) / 2.0;
                        xOffset = this.getBounds().getX() + xLeftMargin + gridStep * (double)categoryCounter++ + barMargin;
                    } else {
                        barWidth = gridStep / (double)this.chart.getSeriesMap().size() * barWidthPercentage;
                        barMargin = gridStep * (1.0 - barWidthPercentage) / 2.0;
                        xOffset = this.getBounds().getX() + xLeftMargin + gridStep * (double)categoryCounter++ + (double)seriesCounter * barWidth + barMargin;
                    }
                    if (series.getCategorySeriesRenderStyle() == CategorySeriesRenderStyle.SteppedBar) {
                        double yCenter = zeroOffset;
                        double yTip = yOffset;
                        double stepLength = gridStep;
                        if (y < 0.0) {
                            yTip = zeroOffset;
                            yCenter = yOffset;
                        }
                        if (steppedPath == null) {
                            steppedPath = new ArrayList<Point2D.Double>();
                            steppedReturnPath = new ArrayList<Point2D.Double>();
                            steppedPath.add(new Point2D.Double(xOffset, yCenter));
                        } else if (((CategoryStyler)this.stylerCategory).isStacked() && (previousY > 0.0 && y < 0.0 || previousY < 0.0 && y > 0.0)) {
                            this.drawStepBar(g, series, steppedPath, steppedReturnPath);
                            steppedPath.clear();
                            steppedReturnPath.clear();
                            steppedPath.add(new Point2D.Double(xOffset, yCenter));
                        }
                        if (!(yItr.hasNext() || ((CategoryStyler)this.stylerCategory).isOverlapped() || ((CategoryStyler)this.stylerCategory).isStacked())) {
                            double singleBarStep = stepLength / (double)this.chart.getSeriesMap().size();
                            stepLength -= (double)seriesCounter * singleBarStep;
                        }
                        steppedPath.add(new Point2D.Double(xOffset, yTip));
                        steppedPath.add(new Point2D.Double(xOffset + stepLength, yTip));
                        steppedReturnPath.add(new Point2D.Double(xOffset, yCenter));
                        steppedReturnPath.add(new Point2D.Double(xOffset + stepLength, yCenter));
                        previousY = y;
                    }
                    if (series.getCategorySeriesRenderStyle() == CategorySeriesRenderStyle.Bar) {
                        Path2D.Double path = new Path2D.Double();
                        path.moveTo(xOffset, yOffset);
                        path.lineTo(xOffset + barWidth, yOffset);
                        path.lineTo(xOffset + barWidth, zeroOffset);
                        path.lineTo(xOffset, zeroOffset);
                        path.closePath();
                        g.setColor(series.getFillColor());
                        g.fill(path);
                    } else if (CategorySeriesRenderStyle.Stick.equals(series.getCategorySeriesRenderStyle())) {
                        if (series.getLineStyle() != Theme.Series.NONE_STROKE) {
                            g.setColor(series.getLineColor());
                            g.setStroke(series.getLineStyle());
                            Line2D.Double line = new Line2D.Double(xOffset, zeroOffset, xOffset, yOffset);
                            g.draw(line);
                        }
                        if (series.getMarker() != null) {
                            g.setColor(series.getMarkerColor());
                            if (y <= 0.0) {
                                series.getMarker().paint(g, xOffset, zeroOffset, ((AxesChartStyler)this.stylerCategory).getMarkerSize());
                            } else {
                                series.getMarker().paint(g, xOffset, yOffset, ((AxesChartStyler)this.stylerCategory).getMarkerSize());
                            }
                        }
                    } else {
                        if (series.getCategorySeriesRenderStyle() == CategorySeriesRenderStyle.Line && series.getLineStyle() != Theme.Series.NONE_STROKE && previousX != -1.7976931348623157E308 && previousY != -1.7976931348623157E308) {
                            g.setColor(series.getLineColor());
                            g.setStroke(series.getLineStyle());
                            Line2D.Double line = new Line2D.Double(previousX, previousY, xOffset + barWidth / 2.0, yOffset);
                            g.draw(line);
                        }
                        previousX = xOffset + barWidth / 2.0;
                        previousY = yOffset;
                        if (series.getMarker() != null) {
                            g.setColor(series.getMarkerColor());
                            series.getMarker().paint(g, previousX, previousY, ((AxesChartStyler)this.stylerCategory).getMarkerSize());
                        }
                    }
                    if (errorBars == null) continue;
                    double eb = ebItr.next().doubleValue();
                    if (((AxesChartStyler)this.stylerCategory).isErrorBarsColorSeriesColor()) {
                        g.setColor(series.getLineColor());
                    } else {
                        g.setColor(((AxesChartStyler)this.stylerCategory).getErrorBarsColor());
                    }
                    g.setStroke(Theme.Strokes.ERROR_BARS);
                    double errorBarLength = eb / (yMax - yMin) * yTickSpace;
                    double topEBOffset = yOffset - errorBarLength;
                    double bottomEBOffset = yOffset + errorBarLength;
                    double errorBarOffset = xOffset + barWidth / 2.0;
                    Line2D.Double line = new Line2D.Double(errorBarOffset, topEBOffset, errorBarOffset, bottomEBOffset);
                    g.draw(line);
                    line = new Line2D.Double(errorBarOffset - 3.0, bottomEBOffset, errorBarOffset + 3.0, bottomEBOffset);
                    g.draw(line);
                    line = new Line2D.Double(errorBarOffset - 3.0, topEBOffset, errorBarOffset + 3.0, topEBOffset);
                    g.draw(line);
                }
                if (steppedPath != null && !steppedReturnPath.isEmpty()) {
                    this.drawStepBar(g, series, steppedPath, (List<Point2D.Double>)steppedReturnPath);
                }
                ++seriesCounter;
            }
        }

        private void drawStepBarLine(Graphics2D g, S series, Path2D.Double path) {
            if (((AxesChartSeries)series).getLineColor() != null) {
                g.setColor(((AxesChartSeries)series).getLineColor());
                g.setStroke(((AxesChartSeries)series).getLineStyle());
                g.draw(path);
            }
        }

        private void drawStepBarFill(Graphics2D g, S series, Path2D.Double path) {
            if (((Series)series).getFillColor() != null) {
                g.setColor(((Series)series).getFillColor());
                g.fill(path);
            }
        }

        private void drawStepBar(Graphics2D g, S series, List<Point2D.Double> path, List<Point2D.Double> returnPath) {
            Collections.reverse(returnPath);
            returnPath.remove(returnPath.size() - 1);
            path.addAll(returnPath);
            Path2D.Double drawPath = new Path2D.Double();
            Point2D.Double startPoint = path.remove(0);
            drawPath.moveTo(startPoint.getX(), startPoint.getY());
            for (Point2D.Double currentPoint : path) {
                drawPath.lineTo(currentPoint.getX(), currentPoint.getY());
            }
            this.drawStepBarFill(g, series, drawPath);
            drawPath.reset();
            drawPath.moveTo(startPoint.getX(), startPoint.getY());
            List<Point2D.Double> linePath = path.subList(0, path.size() - returnPath.size() + 1);
            for (Point2D.Double currentPoint : linePath) {
                drawPath.lineTo(currentPoint.getX(), currentPoint.getY());
            }
            this.drawStepBarLine(g, series, drawPath);
        }
    }

    private static class CategoryPlot<ST extends CategoryStyler, S extends CategorySeries>
    extends AxesChartPlot<ST, S> {
        private final ST categoryStyler;

        private CategoryPlot(Chart<ST, S> chart) {
            super(chart);
            this.categoryStyler = (CategoryStyler)chart.getStyler();
        }

        @Override
        public void paint(Graphics2D g) {
            this.contentPlot = CategorySeriesRenderStyle.Bar.equals(((CategoryStyler)this.categoryStyler).getDefaultSeriesRenderStyle()) || CategorySeriesRenderStyle.Stick.equals(((CategoryStyler)this.categoryStyler).getDefaultSeriesRenderStyle()) ? new ContentPlotCategoryBar(this.chart) : new ContentPlotCategoryLineAreaScatter(this.chart);
            super.paint(g);
        }
    }
}

