/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.formatter;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import org.xbib.graphics.chart.axis.Direction;
import org.xbib.graphics.chart.style.AxesChartStyler;

public class NumberFormatter
extends Format {
    private final AxesChartStyler styler;
    private final Direction axisDirection;
    private final double min;
    private final double max;
    private final NumberFormat numberFormat;

    public NumberFormatter(AxesChartStyler styler, Direction axisDirection, double min, double max) {
        this.styler = styler;
        this.axisDirection = axisDirection;
        this.min = min;
        this.max = max;
        this.numberFormat = NumberFormat.getNumberInstance(styler.getLocale());
    }

    public String getFormatPattern(BigDecimal value) {
        if (value.compareTo(BigDecimal.ZERO) == 0) {
            return "0";
        }
        double difference = this.max - this.min;
        int placeOfDifference = difference == 0.0 ? 0 : (int)Math.floor(Math.log(difference) / Math.log(10.0));
        int placeOfValue = value.doubleValue() == 0.0 ? 0 : (int)Math.floor(Math.log(value.doubleValue()) / Math.log(10.0));
        if (placeOfDifference <= 4 && placeOfDifference >= -4) {
            return this.getNormalDecimalPatternPositive(placeOfValue);
        }
        return this.getScientificDecimalPattern();
    }

    private String getNormalDecimalPatternPositive(int placeOfValue) {
        int maxNumPlaces = 15;
        StringBuilder sb = new StringBuilder();
        for (int i = maxNumPlaces - 1; i >= -1 * maxNumPlaces; --i) {
            if (i >= 0 && i < placeOfValue) {
                sb.append("0");
            } else if (i < 0 && i > placeOfValue) {
                sb.append("0");
            } else {
                sb.append("#");
            }
            if (i % 3 == 0 && i > 0) {
                sb.append(",");
            }
            if (i != 0) continue;
            sb.append(".");
        }
        return sb.toString();
    }

    private String getScientificDecimalPattern() {
        return "0.###############E0";
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        Number value = (Number)obj;
        String decimalPattern = this.axisDirection == Direction.X && this.styler.getXAxisDecimalPattern() != null ? this.styler.getXAxisDecimalPattern() : (this.axisDirection == Direction.Y && this.styler.getYAxisDecimalPattern() != null ? this.styler.getYAxisDecimalPattern() : (this.styler.getDecimalPattern() != null ? this.styler.getDecimalPattern() : this.getFormatPattern(BigDecimal.valueOf(value.doubleValue()))));
        DecimalFormat normalFormat = (DecimalFormat)this.numberFormat;
        normalFormat.applyPattern(decimalPattern);
        toAppendTo.append(normalFormat.format(value));
        return toAppendTo;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        return null;
    }
}

