/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.formatter;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import org.xbib.graphics.chart.axis.Direction;
import org.xbib.graphics.chart.style.AxesChartStyler;

public class NumberLogFormatter
extends Format {
    private final AxesChartStyler styler;
    private final Direction axisDirection;
    private final NumberFormat numberFormat;

    public NumberLogFormatter(AxesChartStyler styler, Direction axisDirection) {
        this.styler = styler;
        this.axisDirection = axisDirection;
        this.numberFormat = NumberFormat.getNumberInstance(styler.getLocale());
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        double number = (Double)obj;
        String decimalPattern = this.axisDirection == Direction.X && this.styler.getXAxisDecimalPattern() != null ? this.styler.getXAxisDecimalPattern() : (this.axisDirection == Direction.Y && this.styler.getYAxisDecimalPattern() != null ? this.styler.getYAxisDecimalPattern() : (this.styler.getDecimalPattern() != null ? this.styler.getDecimalPattern() : (Math.abs(number) > 1000.0 || Math.abs(number) < 0.001 ? "0E0" : "0.###")));
        DecimalFormat normalFormat = (DecimalFormat)this.numberFormat;
        normalFormat.applyPattern(decimalPattern);
        toAppendTo.append(normalFormat.format(number));
        return toAppendTo;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        return null;
    }
}

