/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.xbib.graphics.chart.xy.XYSeries;

public class CSVExporter {
    private static final String LF = System.getProperty("line.separator");

    public static void writeCSVRows(XYSeries series, Path path) throws IOException {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(path, new OpenOption[0]), StandardCharsets.UTF_8));){
            String csv = CSVExporter.join(series.getXData()) + LF;
            bufferedWriter.write(csv);
            csv = CSVExporter.join(series.getYData()) + LF;
            bufferedWriter.write(csv);
            if (series.getExtraValues() != null) {
                csv = CSVExporter.join(series.getExtraValues()) + LF;
                bufferedWriter.write(csv);
            }
        }
    }

    public static void writeCSVColumns(XYSeries series, Path path) throws IOException {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(path, new OpenOption[0]), StandardCharsets.UTF_8));){
            List<?> xData = series.getXData();
            List<? extends Number> yData = series.getYData();
            List<? extends Number> errorBarData = series.getExtraValues();
            Iterator itrx = xData.iterator();
            Iterator itry = yData.iterator();
            Iterator itrErrorBar = null;
            if (errorBarData != null) {
                itrErrorBar = errorBarData.iterator();
            }
            while (itrx.hasNext()) {
                Number xDataPoint = (Number)itrx.next();
                Number yDataPoint = (Number)itry.next();
                Number errorBarValue = null;
                if (itrErrorBar != null) {
                    errorBarValue = (Number)itrErrorBar.next();
                }
                StringBuilder sb = new StringBuilder();
                sb.append(xDataPoint).append(",");
                sb.append(yDataPoint).append(",");
                if (errorBarValue != null) {
                    sb.append(errorBarValue).append(",");
                }
                sb.append(LF);
                bufferedWriter.write(sb.toString());
            }
        }
    }

    private static String join(Collection<?> collection) {
        if (collection == null) {
            return null;
        }
        Iterator<?> iterator = collection.iterator();
        if (!iterator.hasNext()) {
            return "";
        }
        Object first = iterator.next();
        if (!iterator.hasNext()) {
            return first == null ? "" : first.toString();
        }
        StringBuilder sb = new StringBuilder();
        if (first != null) {
            sb.append(first);
        }
        while (iterator.hasNext()) {
            sb.append(",");
            Object obj = iterator.next();
            if (obj == null) continue;
            sb.append(obj);
        }
        return sb.toString();
    }
}

