/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.io.vector;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.xbib.graphics.chart.io.vector.Document;
import org.xbib.graphics.chart.io.vector.Processor;
import org.xbib.graphics.chart.io.vector.VectorGraphics2D;
import org.xbib.graphics.chart.io.vector.util.PageSize;

public abstract class ProcessingPipeline
extends VectorGraphics2D {
    private final PageSize pageSize;

    public ProcessingPipeline(double x, double y, double width, double height) {
        this.pageSize = new PageSize(x, y, width, height);
    }

    public PageSize getPageSize() {
        return this.pageSize;
    }

    protected abstract Processor getProcessor();

    public void writeTo(OutputStream out) throws IOException {
        Document doc = this.getProcessor().process(this.getCommands(), this.getPageSize());
        doc.write(out);
    }

    public byte[] getBytes() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.writeTo(out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return out.toByteArray();
    }
}

