/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.io.vector;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xbib.graphics.chart.io.vector.GraphicsState;
import org.xbib.graphics.chart.io.vector.intermediate.commands.Command;
import org.xbib.graphics.chart.io.vector.intermediate.commands.CreateCommand;
import org.xbib.graphics.chart.io.vector.intermediate.commands.DisposeCommand;
import org.xbib.graphics.chart.io.vector.intermediate.commands.DrawImageCommand;
import org.xbib.graphics.chart.io.vector.intermediate.commands.DrawShapeCommand;
import org.xbib.graphics.chart.io.vector.intermediate.commands.DrawStringCommand;
import org.xbib.graphics.chart.io.vector.intermediate.commands.FillShapeCommand;
import org.xbib.graphics.chart.io.vector.intermediate.commands.RotateCommand;
import org.xbib.graphics.chart.io.vector.intermediate.commands.ScaleCommand;
import org.xbib.graphics.chart.io.vector.intermediate.commands.SetBackgroundCommand;
import org.xbib.graphics.chart.io.vector.intermediate.commands.SetClipCommand;
import org.xbib.graphics.chart.io.vector.intermediate.commands.SetColorCommand;
import org.xbib.graphics.chart.io.vector.intermediate.commands.SetCompositeCommand;
import org.xbib.graphics.chart.io.vector.intermediate.commands.SetFontCommand;
import org.xbib.graphics.chart.io.vector.intermediate.commands.SetHintCommand;
import org.xbib.graphics.chart.io.vector.intermediate.commands.SetPaintCommand;
import org.xbib.graphics.chart.io.vector.intermediate.commands.SetStrokeCommand;
import org.xbib.graphics.chart.io.vector.intermediate.commands.SetTransformCommand;
import org.xbib.graphics.chart.io.vector.intermediate.commands.SetXORModeCommand;
import org.xbib.graphics.chart.io.vector.intermediate.commands.ShearCommand;
import org.xbib.graphics.chart.io.vector.intermediate.commands.TransformCommand;
import org.xbib.graphics.chart.io.vector.intermediate.commands.TranslateCommand;
import org.xbib.graphics.chart.io.vector.util.GraphicsUtils;

public class VectorGraphics2D
extends Graphics2D
implements Cloneable {
    private final List<Command<?>> commands = new LinkedList();
    private final FontRenderContext fontRenderContext;
    private boolean disposed;
    private GraphicsState state;
    private Graphics2D _debug_validate_graphics;

    public VectorGraphics2D() {
        this.emit(new CreateCommand(this));
        this.fontRenderContext = new FontRenderContext(null, false, true);
        this.state = new GraphicsState();
        BufferedImage _debug_validate_bimg = new BufferedImage(200, 250, 2);
        this._debug_validate_graphics = (Graphics2D)_debug_validate_bimg.getGraphics();
        this._debug_validate_graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    private static Shape intersectShapes(Shape s1, Shape s2) {
        if (s1 instanceof Rectangle2D && s2 instanceof Rectangle2D) {
            Rectangle2D r1 = (Rectangle2D)s1;
            Rectangle2D r2 = (Rectangle2D)s2;
            double x1 = Math.max(r1.getMinX(), r2.getMinX());
            double y1 = Math.max(r1.getMinY(), r2.getMinY());
            double x2 = Math.min(r1.getMaxX(), r2.getMaxX());
            double y2 = Math.min(r1.getMaxY(), r2.getMaxY());
            Rectangle2D.Double intersection = new Rectangle2D.Double();
            if (x2 < x1 || y2 < y1) {
                intersection.setFrameFromDiagonal(0.0, 0.0, 0.0, 0.0);
            } else {
                intersection.setFrameFromDiagonal(x1, y1, x2, y2);
            }
            return intersection;
        }
        Area intersection = new Area(s1);
        intersection.intersect(new Area(s2));
        return intersection;
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            VectorGraphics2D clone = (VectorGraphics2D)super.clone();
            clone.state = (GraphicsState)this.state.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        if (this.isDisposed()) {
            return;
        }
        for (Map.Entry<?, ?> entry : hints.entrySet()) {
            this.setRenderingHint((RenderingHints.Key)entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clip(Shape s) {
        this._debug_validate_graphics.clip(s);
        Shape clipOld = this.getClip();
        Shape clip = this.getClip();
        if (clip != null && s != null) {
            s = VectorGraphics2D.intersectShapes(clip, s);
        }
        this.setClip(s);
        Shape clipNew = this.getClip();
        if ((clipNew == null || this._debug_validate_graphics.getClip() == null) && clipNew != this._debug_validate_graphics.getClip()) {
            System.err.println("clip() validation failed: clip(" + clipOld + ", " + s + ") => " + clipNew + " != " + this._debug_validate_graphics.getClip());
        }
        if (clipNew != null && !GraphicsUtils.equals(clipNew, this._debug_validate_graphics.getClip())) {
            System.err.println("clip() validation failed: clip(" + clipOld + ", " + s + ") => " + clipNew + " != " + this._debug_validate_graphics.getClip());
        }
    }

    @Override
    public void draw(Shape s) {
        if (this.isDisposed() || s == null) {
            return;
        }
        this.emit(new DrawShapeCommand(s));
        this._debug_validate_graphics.draw(s);
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        Shape s = g.getOutline(x, y);
        this.draw(s);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        BufferedImage bimg = this.getTransformedImage(img, xform);
        return this.drawImage(bimg, bimg.getMinX(), bimg.getMinY(), bimg.getWidth(), bimg.getHeight(), null, null);
    }

    private BufferedImage getTransformedImage(Image image, AffineTransform xform) {
        Integer interpolationType = (Integer)this.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
        interpolationType = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR.equals(interpolationType) ? Integer.valueOf(1) : (RenderingHints.VALUE_INTERPOLATION_BILINEAR.equals(interpolationType) ? Integer.valueOf(2) : Integer.valueOf(3));
        AffineTransformOp op = new AffineTransformOp(xform, interpolationType);
        BufferedImage bufferedImage = GraphicsUtils.toBufferedImage(image);
        return op.filter(bufferedImage, null);
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        if (op != null) {
            img = op.filter(img, null);
        }
        this.drawImage(img, x, y, img.getWidth(), img.getHeight(), null, null);
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.drawRenderedImage(img.createDefaultRendering(), xform);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        BufferedImage bimg = GraphicsUtils.toBufferedImage(img);
        this.drawImage(bimg, xform, null);
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.drawString(str, (float)x, (float)y);
    }

    @Override
    public void drawString(String str, float x, float y) {
        if (this.isDisposed() || str == null || str.trim().length() == 0) {
            return;
        }
        boolean isTextAsVectors = false;
        if (isTextAsVectors) {
            TextLayout layout = new TextLayout(str, this.getFont(), this.getFontRenderContext());
            Shape s = layout.getOutline(AffineTransform.getTranslateInstance(x, y));
            this.fill(s);
        } else {
            this.emit(new DrawStringCommand(str, x, y));
            this._debug_validate_graphics.drawString(str, x, y);
        }
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.drawString(iterator, (float)x, (float)y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        StringBuilder buf = new StringBuilder();
        char c = iterator.first();
        while (c != '\uffff') {
            buf.append(c);
            c = iterator.next();
        }
        this.drawString(buf.toString(), x, y);
    }

    @Override
    public void fill(Shape s) {
        if (this.isDisposed() || s == null) {
            return;
        }
        this.emit(new FillShapeCommand(s));
        this._debug_validate_graphics.fill(s);
    }

    @Override
    public Color getBackground() {
        return this.state.getBackground();
    }

    @Override
    public void setBackground(Color color) {
        if (this.isDisposed() || color == null || this.getColor().equals(color)) {
            return;
        }
        this.emit(new SetBackgroundCommand(color));
        this.state.setBackground(color);
        this._debug_validate_graphics.setBackground(color);
        if (!this.getBackground().equals(this._debug_validate_graphics.getBackground())) {
            System.err.println("setBackground() validation failed");
        }
    }

    @Override
    public Composite getComposite() {
        return this.state.getComposite();
    }

    @Override
    public void setComposite(Composite comp) {
        if (this.isDisposed()) {
            return;
        }
        if (comp == null) {
            throw new IllegalArgumentException("Cannot set a null composite.");
        }
        this.emit(new SetCompositeCommand(comp));
        this.state.setComposite(comp);
        this._debug_validate_graphics.setComposite(comp);
        if (!this.getComposite().equals(this._debug_validate_graphics.getComposite())) {
            System.err.println("setComposite() validation failed");
        }
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        throw new UnsupportedOperationException();
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.fontRenderContext;
    }

    @Override
    public Paint getPaint() {
        return this.state.getPaint();
    }

    @Override
    public void setPaint(Paint paint) {
        if (this.isDisposed() || paint == null) {
            return;
        }
        if (paint instanceof Color) {
            this.setColor((Color)paint);
            return;
        }
        if (this.getPaint().equals(paint)) {
            return;
        }
        this.emit(new SetPaintCommand(paint));
        this.state.setPaint(paint);
        this._debug_validate_graphics.setPaint(paint);
        if (!this.getPaint().equals(this._debug_validate_graphics.getPaint())) {
            System.err.println("setPaint() validation failed");
        }
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        if (RenderingHints.KEY_ANTIALIASING.equals(hintKey)) {
            return RenderingHints.VALUE_ANTIALIAS_OFF;
        }
        if (RenderingHints.KEY_TEXT_ANTIALIASING.equals(hintKey)) {
            return RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
        }
        if (RenderingHints.KEY_FRACTIONALMETRICS.equals(hintKey)) {
            return RenderingHints.VALUE_FRACTIONALMETRICS_ON;
        }
        return this.state.getHints().get(hintKey);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return (RenderingHints)this.state.getHints().clone();
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        if (this.isDisposed()) {
            return;
        }
        this.state.getHints().clear();
        for (Map.Entry<?, ?> hint : hints.entrySet()) {
            this.setRenderingHint((RenderingHints.Key)hint.getKey(), hint.getValue());
        }
    }

    @Override
    public Stroke getStroke() {
        return this.state.getStroke();
    }

    @Override
    public void setStroke(Stroke s) {
        if (this.isDisposed()) {
            return;
        }
        if (s == null) {
            throw new IllegalArgumentException("Cannot set a null stroke.");
        }
        this.emit(new SetStrokeCommand(s));
        this.state.setStroke(s);
        this._debug_validate_graphics.setStroke(s);
        if (!this.getStroke().equals(this._debug_validate_graphics.getStroke())) {
            System.err.println("setStroke() validation failed");
        }
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        boolean _debug_hit;
        boolean hit;
        Shape hitShape = s;
        if (onStroke) {
            hitShape = this.getStroke().createStrokedShape(hitShape);
        }
        if ((hit = (hitShape = this.state.transformShape(hitShape)).intersects(rect)) != (_debug_hit = this._debug_validate_graphics.hit(rect, s, onStroke))) {
            System.err.println("setClip() validation failed");
        }
        return hit;
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        if (this.isDisposed()) {
            return;
        }
        this.state.getHints().put(hintKey, hintValue);
        this.emit(new SetHintCommand(hintKey, hintValue));
    }

    @Override
    public AffineTransform getTransform() {
        return new AffineTransform(this.state.getTransform());
    }

    @Override
    public void setTransform(AffineTransform tx) {
        if (this.isDisposed() || tx == null || this.state.getTransform().equals(tx)) {
            return;
        }
        this.emit(new SetTransformCommand(tx));
        this.state.setTransform(tx);
        this._debug_validate_graphics.setTransform(tx);
        if (!this.getTransform().equals(this._debug_validate_graphics.getTransform())) {
            System.err.println("setTransform() validation failed");
        }
    }

    @Override
    public void shear(double shx, double shy) {
        if (shx == 0.0 && shy == 0.0) {
            return;
        }
        AffineTransform txNew = this.getTransform();
        txNew.shear(shx, shy);
        this.emit(new ShearCommand(shx, shy));
        this.state.setTransform(txNew);
        this._debug_validate_graphics.shear(shx, shy);
        if (!this.getTransform().equals(this._debug_validate_graphics.getTransform())) {
            System.err.println("shear() validation failed");
        }
    }

    @Override
    public void transform(AffineTransform tx) {
        if (tx.isIdentity()) {
            return;
        }
        AffineTransform txNew = this.getTransform();
        txNew.concatenate(tx);
        this.emit(new TransformCommand(tx));
        this.state.setTransform(txNew);
        this._debug_validate_graphics.transform(tx);
        if (!this.getTransform().equals(this._debug_validate_graphics.getTransform())) {
            System.err.println("transform() validation failed");
        }
    }

    @Override
    public void translate(int x, int y) {
        this.translate((double)x, (double)y);
    }

    @Override
    public void translate(double tx, double ty) {
        if (tx == 0.0 && ty == 0.0) {
            return;
        }
        AffineTransform txNew = this.getTransform();
        txNew.translate(tx, ty);
        this.emit(new TranslateCommand(tx, ty));
        this.state.setTransform(txNew);
        this._debug_validate_graphics.translate(tx, ty);
        if (!this.getTransform().equals(this._debug_validate_graphics.getTransform())) {
            System.err.println("translate() validation failed");
        }
    }

    @Override
    public void rotate(double theta) {
        this.rotate(theta, 0.0, 0.0);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        if (theta == 0.0) {
            return;
        }
        AffineTransform txNew = this.getTransform();
        if (x == 0.0 && y == 0.0) {
            txNew.rotate(theta);
        } else {
            txNew.rotate(theta, x, y);
        }
        this.emit(new RotateCommand(theta, x, y));
        this.state.setTransform(txNew);
        if (x == 0.0 && y == 0.0) {
            this._debug_validate_graphics.rotate(theta);
            if (!this.getTransform().equals(this._debug_validate_graphics.getTransform())) {
                System.err.println("rotate(theta) validation failed");
            }
        } else {
            this._debug_validate_graphics.rotate(theta, x, y);
            if (!this.getTransform().equals(this._debug_validate_graphics.getTransform())) {
                System.err.println("rotate(theta,x,y) validation failed");
            }
        }
    }

    @Override
    public void scale(double sx, double sy) {
        if (sx == 1.0 && sy == 1.0) {
            return;
        }
        AffineTransform txNew = this.getTransform();
        txNew.scale(sx, sy);
        this.emit(new ScaleCommand(sx, sy));
        this.state.setTransform(txNew);
        this._debug_validate_graphics.scale(sx, sy);
        if (!this.getTransform().equals(this._debug_validate_graphics.getTransform())) {
            System.err.println("scale() validation failed");
        }
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        Color colorOld = this.getColor();
        this.setColor(this.getBackground());
        this.fillRect(x, y, width, height);
        this.setColor(colorOld);
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.clip(new Rectangle(x, y, width, height));
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    @Override
    public Graphics create() {
        if (this.isDisposed()) {
            return null;
        }
        VectorGraphics2D clone = null;
        try {
            clone = (VectorGraphics2D)this.clone();
            this.emit(new CreateCommand(clone));
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        if (clone != null) {
            clone._debug_validate_graphics = (Graphics2D)this._debug_validate_graphics.create();
        }
        return clone;
    }

    @Override
    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.emit(new DisposeCommand(this));
        this.disposed = true;
        this._debug_validate_graphics.dispose();
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.draw(new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 0));
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.drawImage(img, x, y, img.getWidth(observer), img.getHeight(observer), null, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.drawImage(img, x, y, img.getWidth(observer), img.getHeight(observer), bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.drawImage(img, x, y, width, height, null, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        if (this.isDisposed() || img == null) {
            return true;
        }
        int imageWidth = img.getWidth(observer);
        int imageHeight = img.getHeight(observer);
        Rectangle bounds = new Rectangle(x, y, width, height);
        if (bgcolor != null) {
            Color bgcolorOld = this.getColor();
            this.setColor(bgcolor);
            this.fill(bounds);
            this.setColor(bgcolorOld);
        }
        this.emit(new DrawImageCommand(img, imageWidth, imageHeight, x, y, width, height));
        this._debug_validate_graphics.drawImage(img, x, y, width, height, bgcolor, observer);
        return true;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        if (img == null) {
            return true;
        }
        int sx = Math.min(sx1, sx2);
        int sy = Math.min(sy1, sy2);
        int sw = Math.abs(sx2 - sx1);
        int sh = Math.abs(sy2 - sy1);
        int dx = Math.min(dx1, dx2);
        int dy = Math.min(dy1, dy2);
        int dw = Math.abs(dx2 - dx1);
        int dh = Math.abs(dy2 - dy1);
        BufferedImage bufferedImg = GraphicsUtils.toBufferedImage(img);
        BufferedImage cropped = bufferedImg.getSubimage(sx, sy, sw, sh);
        return this.drawImage(cropped, dx, dy, dw, dh, bgcolor, observer);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.draw(new Line2D.Double(x1, y1, x2, y2));
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.draw(new Ellipse2D.Double(x, y, width, height));
    }

    @Override
    public void drawPolygon(Polygon p) {
        this.draw(p);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.draw(new Polygon(xPoints, yPoints, nPoints));
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        Path2D.Float p = new Path2D.Float();
        for (int i = 0; i < nPoints; ++i) {
            if (i > 0) {
                ((Path2D)p).lineTo(xPoints[i], yPoints[i]);
                continue;
            }
            ((Path2D)p).moveTo(xPoints[i], yPoints[i]);
        }
        this.draw(p);
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        this.draw(new Rectangle(x, y, width, height));
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.draw(new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight));
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.fill(new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 2));
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.fill(new Ellipse2D.Double(x, y, width, height));
    }

    @Override
    public void fillPolygon(Polygon p) {
        this.fill(p);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.fill(new Polygon(xPoints, yPoints, nPoints));
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.fill(new Rectangle(x, y, width, height));
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.fill(new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight));
    }

    @Override
    public Shape getClip() {
        return this.state.getClip();
    }

    @Override
    public void setClip(Shape clip) {
        if (this.isDisposed()) {
            return;
        }
        this.emit(new SetClipCommand(clip));
        this.state.setClip(clip);
        this._debug_validate_graphics.setClip(clip);
        if (this.getClip() == null) {
            if (this._debug_validate_graphics.getClip() != null) {
                System.err.printf("setClip() validation failed: clip=null, validation=%s\n", this._debug_validate_graphics.getClip());
            }
        } else if (!GraphicsUtils.equals(this.getClip(), this._debug_validate_graphics.getClip())) {
            System.err.printf("setClip() validation failed: clip=%s, validation=%s\n", this.getClip(), this._debug_validate_graphics.getClip());
        }
    }

    @Override
    public Rectangle getClipBounds() {
        if (this.getClip() == null) {
            return null;
        }
        return this.getClip().getBounds();
    }

    @Override
    public Color getColor() {
        return this.state.getColor();
    }

    @Override
    public void setColor(Color c) {
        if (this.isDisposed() || c == null || this.getColor().equals(c)) {
            return;
        }
        this.emit(new SetColorCommand(c));
        this.state.setColor(c);
        this.state.setPaint(c);
        this._debug_validate_graphics.setColor(c);
        if (!this.getColor().equals(this._debug_validate_graphics.getColor())) {
            System.err.println("setColor() validation failed");
        }
    }

    @Override
    public Font getFont() {
        return this.state.getFont();
    }

    @Override
    public void setFont(Font font) {
        if (this.isDisposed() || font != null && this.getFont().equals(font)) {
            return;
        }
        this.emit(new SetFontCommand(font));
        this.state.setFont(font);
        this._debug_validate_graphics.setFont(font);
        if (!this.getFont().equals(this._debug_validate_graphics.getFont())) {
            System.err.println("setFont() validation failed");
        }
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        BufferedImage bi = new BufferedImage(1, 1, 3);
        Graphics g = bi.getGraphics();
        FontMetrics fontMetrics = g.getFontMetrics(this.getFont());
        g.dispose();
        return fontMetrics;
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.setClip(new Rectangle(x, y, width, height));
    }

    @Override
    public void setPaintMode() {
        this.setComposite(AlphaComposite.SrcOver);
        this._debug_validate_graphics.setPaintMode();
    }

    public Color getXORMode() {
        return this.state.getXorMode();
    }

    @Override
    public void setXORMode(Color c1) {
        if (this.isDisposed() || c1 == null) {
            return;
        }
        this.emit(new SetXORModeCommand(c1));
        this.state.setXorMode(c1);
        this._debug_validate_graphics.setXORMode(c1);
    }

    private void emit(Command<?> command) {
        this.commands.add(command);
    }

    protected Iterable<Command<?>> getCommands() {
        return this.commands;
    }

    protected boolean isDisposed() {
        return this.disposed;
    }
}

