/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.io.vector.intermediate.filters;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import org.xbib.graphics.chart.io.vector.intermediate.commands.AffineTransformCommand;
import org.xbib.graphics.chart.io.vector.intermediate.commands.Command;
import org.xbib.graphics.chart.io.vector.intermediate.commands.CreateCommand;
import org.xbib.graphics.chart.io.vector.intermediate.commands.DisposeCommand;
import org.xbib.graphics.chart.io.vector.intermediate.commands.SetTransformCommand;
import org.xbib.graphics.chart.io.vector.intermediate.commands.TransformCommand;
import org.xbib.graphics.chart.io.vector.intermediate.filters.Filter;

public class AbsoluteToRelativeTransformsFilter
extends Filter {
    private Stack<AffineTransform> transforms = new Stack();

    public AbsoluteToRelativeTransformsFilter(Iterable<Command<?>> stream) {
        super(stream);
    }

    @Override
    public Command<?> next() {
        Object nextCommand = super.next();
        if (nextCommand instanceof AffineTransformCommand) {
            AffineTransformCommand affineTransformCommand = (AffineTransformCommand)nextCommand;
            this.getCurrentTransform().concatenate((AffineTransform)affineTransformCommand.getValue());
        } else if (nextCommand instanceof CreateCommand) {
            AffineTransform newTransform = this.transforms.isEmpty() ? new AffineTransform() : new AffineTransform(this.getCurrentTransform());
            this.transforms.push(newTransform);
        } else if (nextCommand instanceof DisposeCommand) {
            this.transforms.pop();
        }
        return nextCommand;
    }

    @Override
    protected List<Command<?>> filter(Command<?> command) {
        if (command instanceof SetTransformCommand) {
            SetTransformCommand setTransformCommand = (SetTransformCommand)command;
            AffineTransform absoluteTransform = (AffineTransform)setTransformCommand.getValue();
            AffineTransform relativeTransform = new AffineTransform();
            try {
                AffineTransform invertedOldTransformation = this.getCurrentTransform().createInverse();
                relativeTransform.concatenate(invertedOldTransformation);
            }
            catch (NoninvertibleTransformException e) {
                e.printStackTrace();
            }
            relativeTransform.concatenate(absoluteTransform);
            TransformCommand transformCommand = new TransformCommand(relativeTransform);
            return Arrays.asList(transformCommand);
        }
        return Arrays.asList(command);
    }

    private AffineTransform getCurrentTransform() {
        return this.transforms.peek();
    }
}

